/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.types;

import io.vertx.core.Vertx;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceReference;
import io.vertx.servicediscovery.impl.DiscoveryImpl;
import io.vertx.servicediscovery.utils.ClassLoaderUtils;

public abstract class AbstractServiceReference<T>
implements ServiceReference {
    private final ServiceDiscovery discovery;
    private final Record record;
    protected T service;
    protected final Vertx vertx;

    public AbstractServiceReference(Vertx vertx, ServiceDiscovery discovery, Record record) {
        this.record = record;
        this.discovery = discovery;
        this.vertx = vertx;
    }

    public synchronized <X> X cached() {
        return (X)this.service;
    }

    public synchronized <X> X get() {
        if (this.service == null) {
            this.service = this.retrieve();
        }
        return this.cached();
    }

    @Override
    public <X> X getAs(Class<X> x) {
        X svc = this.get();
        if (x == null || x.isInstance(svc)) {
            return svc;
        }
        return ClassLoaderUtils.createWithDelegate(x, svc);
    }

    @Override
    public <X> X cachedAs(Class<X> x) {
        X svc = this.cached();
        if (svc == null) {
            return null;
        }
        if (x == null || x.isInstance(svc)) {
            return svc;
        }
        return ClassLoaderUtils.createWithDelegate(x, svc);
    }

    protected abstract T retrieve();

    protected void onClose() {
    }

    @Override
    public Record record() {
        return this.record;
    }

    @Override
    public synchronized void release() {
        ((DiscoveryImpl)this.discovery).unbind(this);
        if (this.service != null) {
            this.onClose();
            this.service = null;
        }
    }

    @Override
    public void close() {
        this.release();
    }

    @Override
    public synchronized boolean isHolding(Object object) {
        return this.service != null && (object.hashCode() == this.service.hashCode() || object.equals(this.service));
    }
}

