/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.impl;

import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import java.util.Iterator;
import java.util.ServiceLoader;

public interface ShellAuth {
    public String provider();

    public AuthProvider create(Vertx var1, JsonObject var2);

    public static AuthProvider load(Vertx vertx, JsonObject config) {
        ServiceLoader<ShellAuth> loader = ServiceLoader.load(ShellAuth.class);
        Iterator<ShellAuth> factories = loader.iterator();
        while (factories.hasNext()) {
            try {
                ShellAuth auth = factories.next();
                if (auth == null || !auth.provider().equals(config.getString("provider", ""))) continue;
                return auth.create(vertx, config);
            }
            catch (RuntimeException runtimeException) {
            }
        }
        throw new VertxException("Provider not found [" + config.getString("provider", "") + "] / check your classpath");
    }
}

