/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.impl.auth;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.jdbc.JDBCAuth;
import io.vertx.ext.auth.jdbc.JDBCAuthOptions;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.shell.impl.ShellAuth;

public class JDBCShellAuth
implements ShellAuth {
    @Override
    public String provider() {
        return "jdbc";
    }

    @Override
    public AuthProvider create(Vertx vertx, JsonObject config) {
        String datasourceName;
        JDBCAuthOptions options = new JDBCAuthOptions(config);
        JDBCClient client = options.isShared() ? ((datasourceName = options.getDatasourceName()) != null ? JDBCClient.createShared((Vertx)vertx, (JsonObject)options.getConfig(), (String)datasourceName) : JDBCClient.createShared((Vertx)vertx, (JsonObject)options.getConfig())) : JDBCClient.create((Vertx)vertx, (JsonObject)options.getConfig());
        JDBCAuth auth = JDBCAuth.create((Vertx)vertx, (JDBCClient)client);
        if (options.getAuthenticationQuery() != null) {
            auth.setAuthenticationQuery(options.getAuthenticationQuery());
        }
        if (options.getRolesQuery() != null) {
            auth.setRolesQuery(options.getRolesQuery());
        }
        if (options.getPermissionsQuery() != null) {
            auth.setPermissionsQuery(options.getPermissionsQuery());
        }
        if (options.getRolesPrefix() != null) {
            auth.setRolePrefix(options.getRolesPrefix());
        }
        return auth;
    }
}

