/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.term;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.ext.shell.term.SSHTermOptionsConverter;
import java.nio.charset.StandardCharsets;
import java.util.Map;

@DataObject(generateConverter=true)
public class SSHTermOptions {
    public static final String DEFAULT_HOST = "0.0.0.0";
    public static final int DEFAULT_PORT = 0;
    public static final String DEFAULT_DEFAULT_CHARSET = StandardCharsets.UTF_8.name();
    public static final String DEFAULT_INPUTRC = "/io/vertx/ext/shell/inputrc";
    private String host;
    private int port;
    private KeyCertOptions keyPairOptions;
    private JsonObject authOptions;
    private String defaultCharset;
    private String intputrc;

    public SSHTermOptions() {
        this.host = DEFAULT_HOST;
        this.port = 0;
        this.defaultCharset = DEFAULT_DEFAULT_CHARSET;
        this.intputrc = DEFAULT_INPUTRC;
    }

    public SSHTermOptions(SSHTermOptions that) {
        this.host = that.host;
        this.port = that.port;
        this.keyPairOptions = that.keyPairOptions != null ? that.keyPairOptions.copy() : null;
        this.authOptions = that.authOptions != null ? that.authOptions.copy() : null;
        this.defaultCharset = that.defaultCharset;
        this.intputrc = that.intputrc;
    }

    public SSHTermOptions(JsonObject json) {
        this();
        SSHTermOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public String getHost() {
        return this.host;
    }

    public SSHTermOptions setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public SSHTermOptions setPort(int port) {
        this.port = port;
        return this;
    }

    @GenIgnore
    public KeyCertOptions getKeyPairOptions() {
        return this.keyPairOptions;
    }

    public SSHTermOptions setKeyPairOptions(JksOptions options) {
        this.keyPairOptions = options;
        return this;
    }

    public SSHTermOptions setPfxKeyPairOptions(PfxOptions options) {
        this.keyPairOptions = options;
        return this;
    }

    public SSHTermOptions setPemKeyPairOptions(PemKeyCertOptions options) {
        this.keyPairOptions = options;
        return this;
    }

    public JsonObject getAuthOptions() {
        return this.authOptions;
    }

    public SSHTermOptions setAuthOptions(JsonObject authOptions) {
        this.authOptions = authOptions;
        return this;
    }

    public String getDefaultCharset() {
        return this.defaultCharset;
    }

    public SSHTermOptions setDefaultCharset(String defaultCharset) {
        this.defaultCharset = defaultCharset;
        return this;
    }

    public String getIntputrc() {
        return this.intputrc;
    }

    public SSHTermOptions setIntputrc(String intputrc) {
        this.intputrc = intputrc;
        return this;
    }
}

