/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.vertx.sqlclient.impl.StringLongSequence;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;

public class StringLongSequenceTest {
    @Test
    public void testSequence() {
        StringLongSequence seq = new StringLongSequence();
        StringLongSequenceTest.assertEquals("0000000", seq.next());
        StringLongSequenceTest.assertEquals("0000001", seq.next());
        StringLongSequenceTest.assertEquals("0000002", seq.next());
        StringLongSequenceTest.assertEquals("0000003", seq.next());
        StringLongSequenceTest.assertEquals("0000004", seq.next());
        StringLongSequenceTest.assertEquals("0000005", seq.next());
        StringLongSequenceTest.assertEquals("0000006", seq.next());
        StringLongSequenceTest.assertEquals("0000007", seq.next());
        StringLongSequenceTest.assertEquals("0000008", seq.next());
        StringLongSequenceTest.assertEquals("0000009", seq.next());
        StringLongSequenceTest.assertEquals("000000A", seq.next());
        StringLongSequenceTest.assertEquals("000000B", seq.next());
        StringLongSequenceTest.assertEquals("000000C", seq.next());
        StringLongSequenceTest.assertEquals("000000D", seq.next());
        StringLongSequenceTest.assertEquals("000000E", seq.next());
        StringLongSequenceTest.assertEquals("000000F", seq.next());
        StringLongSequenceTest.assertEquals("0000010", seq.next());
    }

    @Test
    public void testEndingZero() {
        StringLongSequence seq = new StringLongSequence();
        for (int i = 0; i < 10000; ++i) {
            Assert.assertEquals((long)0L, (long)(seq.next() & 0xFFL));
        }
    }

    private static void assertEquals(String s, long l) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeLong(l);
        String actual = buf.getCharSequence(0, 7, StandardCharsets.UTF_8).toString();
        Assert.assertEquals((Object)s, (Object)actual);
    }
}

