/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.tck;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.TestContext;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.tck.Connector;
import org.junit.After;
import org.junit.Before;

public abstract class DataTypeTestBase {
    protected Vertx vertx;
    protected Connector<SqlConnection> connector;

    protected abstract void initConnector();

    protected void connect(Handler<AsyncResult<SqlConnection>> handler) {
        this.connector.connect(handler);
    }

    @Before
    public void setUp(TestContext ctx) throws Exception {
        this.vertx = Vertx.vertx();
        this.initConnector();
    }

    @After
    public void tearDown(TestContext ctx) {
        this.connector.close();
        this.vertx.close(ctx.asyncAssertSuccess());
    }
}

