/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.ArrayTuple;
import io.vertx.sqlclient.impl.PreparedStatement;
import io.vertx.sqlclient.impl.RowSetImpl;
import io.vertx.sqlclient.impl.SqlResultBase;
import io.vertx.sqlclient.impl.SqlResultBuilder;
import io.vertx.sqlclient.impl.SqlResultImpl;
import io.vertx.sqlclient.impl.TupleInternal;
import io.vertx.sqlclient.impl.command.CommandScheduler;
import io.vertx.sqlclient.impl.command.ExtendedBatchQueryCommand;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import io.vertx.sqlclient.impl.command.PrepareStatementCommand;
import io.vertx.sqlclient.impl.command.SimpleQueryCommand;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collector;

public abstract class SqlClientBase<C extends SqlClient>
implements SqlClient,
CommandScheduler {
    public C query(String sql, Handler<AsyncResult<RowSet<Row>>> handler) {
        return this.query(sql, false, RowSetImpl.FACTORY, RowSetImpl.COLLECTOR, handler);
    }

    public <R> C query(String sql, Collector<Row, ?, R> collector, Handler<AsyncResult<SqlResult<R>>> handler) {
        return this.query(sql, true, SqlResultImpl::new, collector, handler);
    }

    private <R1, R2 extends SqlResultBase<R1, R2>, R3 extends SqlResult<R1>> C query(String sql, boolean singleton, Function<R1, R2> factory, Collector<Row, ?, R1> collector, Handler<AsyncResult<R3>> handler) {
        SqlResultBuilder<R1, R2, R3> b = new SqlResultBuilder<R1, R2, R3>(factory, handler);
        this.schedule(new SimpleQueryCommand<R1>(sql, singleton, collector, b), b);
        return (C)this;
    }

    public C preparedQuery(String sql, Tuple arguments, Handler<AsyncResult<RowSet<Row>>> handler) {
        return this.preparedQuery(sql, (TupleInternal)arguments, RowSetImpl.FACTORY, RowSetImpl.COLLECTOR, handler);
    }

    public <R> C preparedQuery(String sql, Tuple arguments, Collector<Row, ?, R> collector, Handler<AsyncResult<SqlResult<R>>> handler) {
        return this.preparedQuery(sql, (TupleInternal)arguments, SqlResultImpl::new, collector, handler);
    }

    private <R1, R2 extends SqlResultBase<R1, R2>, R3 extends SqlResult<R1>> C preparedQuery(String sql, TupleInternal arguments, Function<R1, R2> factory, Collector<Row, ?, R1> collector, Handler<AsyncResult<R3>> handler) {
        this.schedule(new PrepareStatementCommand(sql), cr -> {
            if (cr.succeeded()) {
                PreparedStatement ps = (PreparedStatement)cr.result();
                String msg = ps.prepare(arguments);
                if (msg != null) {
                    handler.handle((Object)Future.failedFuture((String)msg));
                } else {
                    SqlResultBuilder b = new SqlResultBuilder(factory, handler);
                    cr.scheduler.schedule(new ExtendedQueryCommand(ps, arguments, collector, b), b);
                }
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)cr.cause()));
            }
        });
        return (C)this;
    }

    public C preparedQuery(String sql, Handler<AsyncResult<RowSet<Row>>> handler) {
        return this.preparedQuery(sql, ArrayTuple.EMPTY, handler);
    }

    public <R> C preparedQuery(String sql, Collector<Row, ?, R> collector, Handler<AsyncResult<SqlResult<R>>> handler) {
        return this.preparedQuery(sql, ArrayTuple.EMPTY, collector, handler);
    }

    public C preparedBatch(String sql, List<Tuple> batch, Handler<AsyncResult<RowSet<Row>>> handler) {
        return this.preparedBatch(sql, batch, RowSetImpl.FACTORY, RowSetImpl.COLLECTOR, handler);
    }

    public <R> C preparedBatch(String sql, List<Tuple> batch, Collector<Row, ?, R> collector, Handler<AsyncResult<SqlResult<R>>> handler) {
        return this.preparedBatch(sql, batch, SqlResultImpl::new, collector, handler);
    }

    private <R1, R2 extends SqlResultBase<R1, R2>, R3 extends SqlResult<R1>> C preparedBatch(String sql, List<Tuple> batch, Function<R1, R2> factory, Collector<Row, ?, R1> collector, Handler<AsyncResult<R3>> handler) {
        this.schedule(new PrepareStatementCommand(sql), cr -> {
            if (cr.succeeded()) {
                PreparedStatement ps = (PreparedStatement)cr.result();
                for (Tuple args : batch) {
                    String msg = ps.prepare((TupleInternal)args);
                    if (msg == null) continue;
                    handler.handle((Object)Future.failedFuture((String)msg));
                    return;
                }
                SqlResultBuilder b = new SqlResultBuilder(factory, handler);
                cr.scheduler.schedule(new ExtendedBatchQueryCommand(ps, batch, collector, b), b);
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)cr.cause()));
            }
        });
        return (C)this;
    }
}

