/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.sqlclient.PropertyKind;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.impl.QueryResultHandler;
import io.vertx.sqlclient.impl.RowDesc;
import io.vertx.sqlclient.impl.SqlResultBase;
import java.util.HashMap;
import java.util.function.Function;

public class SqlResultBuilder<T, R extends SqlResultBase<T, R>, L extends SqlResult<T>>
implements QueryResultHandler<T>,
Handler<AsyncResult<Boolean>> {
    private final Handler<AsyncResult<L>> handler;
    private final Function<T, R> factory;
    private R first;
    private boolean suspended;

    SqlResultBuilder(Function<T, R> factory, Handler<AsyncResult<L>> handler) {
        this.factory = factory;
        this.handler = handler;
    }

    @Override
    public void handleResult(int updatedCount, int size, RowDesc desc, T result, Throwable failure) {
        SqlResultBase r = (SqlResultBase)this.factory.apply(result);
        r.failure = failure;
        r.updated = updatedCount;
        r.size = size;
        r.columnNames = desc != null ? desc.columnNames() : null;
        this.handleResult(r, failure);
    }

    private void handleResult(R result, Throwable failure) {
        if (this.first == null) {
            this.first = result;
        } else {
            R h = this.first;
            while (((SqlResultBase)h).next != null) {
                h = ((SqlResultBase)h).next;
            }
            ((SqlResultBase)h).next = result;
        }
    }

    @Override
    public <V> void addProperty(PropertyKind<V> property, V value) {
        if (this.first != null) {
            R r = this.first;
            while (((SqlResultBase)r).next != null) {
                r = ((SqlResultBase)r).next;
            }
            if (((SqlResultBase)r).properties == null) {
                ((SqlResultBase)r).properties = new HashMap();
            }
            ((SqlResultBase)r).properties.put(property, value);
        }
    }

    public void handle(AsyncResult<Boolean> res) {
        boolean bl = this.suspended = res.succeeded() && (Boolean)res.result() != false;
        if (res.failed()) {
            this.handler.handle(res);
        } else if (this.first == null) {
            this.handler.handle((Object)Future.succeededFuture());
        } else if (((SqlResultBase)this.first).failure != null) {
            this.handler.handle((Object)Future.failedFuture((Throwable)((SqlResultBase)this.first).failure));
        } else {
            this.handler.handle((Object)Future.succeededFuture(this.first));
        }
    }

    public boolean isSuspended() {
        return this.suspended;
    }
}

