/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.unit.collect;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.rxjava.ext.unit.report.TestSuiteReport;
import io.vertx.rxjava.core.Vertx;
import io.vertx.core.Handler;
import io.vertx.rxjava.core.eventbus.MessageConsumer;
import io.vertx.ext.unit.report.ReportingOptions;

/**
 * The event bus collector listen to events on the Vert.x event bus and translate them
 * into reports.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.unit.collect.EventBusCollector original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.ext.unit.collect.EventBusCollector.class)
public class EventBusCollector {

  public static final io.vertx.lang.rxjava.TypeArg<EventBusCollector> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new EventBusCollector((io.vertx.ext.unit.collect.EventBusCollector) obj),
    EventBusCollector::getDelegate
  );

  private final io.vertx.ext.unit.collect.EventBusCollector delegate;
  
  public EventBusCollector(io.vertx.ext.unit.collect.EventBusCollector delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.unit.collect.EventBusCollector getDelegate() {
    return delegate;
  }

  /**
   * Create a message handler reporting with the specified options. The returned
   * message handler can be registered to an event bus.
   * @param vertx 
   * @param options the reporting options
   * @return the message handler
   */
  public static EventBusCollector create(Vertx vertx, ReportingOptions options) { 
    EventBusCollector ret = EventBusCollector.newInstance(io.vertx.ext.unit.collect.EventBusCollector.create(vertx.getDelegate(), options));
    return ret;
  }

  public static EventBusCollector create(Vertx vertx, Handler<TestSuiteReport> reporter) { 
    EventBusCollector ret = EventBusCollector.newInstance(io.vertx.ext.unit.collect.EventBusCollector.create(vertx.getDelegate(), new Handler<io.vertx.ext.unit.report.TestSuiteReport>() {
      public void handle(io.vertx.ext.unit.report.TestSuiteReport event) {
        reporter.handle(TestSuiteReport.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * Register the collector as a consumer of the event bus with the specified address.
   * @param address the registration address
   * @return the subscribed message consumer
   */
  public MessageConsumer register(String address) { 
    MessageConsumer ret = MessageConsumer.newInstance(delegate.register(address));
    return ret;
  }


  public static EventBusCollector newInstance(io.vertx.ext.unit.collect.EventBusCollector arg) {
    return arg != null ? new EventBusCollector(arg) : null;
  }
}
