/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.unit.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.ext.unit.Completion;
import io.vertx.ext.unit.impl.Helper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CompletionImpl<T>
implements Completion<T> {
    protected final CompletableFuture<T> completable = new CompletableFuture();

    @Override
    public void resolve(Future future) {
        this.completable.whenComplete((done, err) -> {
            if (err != null) {
                future.fail(err);
            } else {
                future.complete();
            }
        });
    }

    @Override
    public boolean isCompleted() {
        return this.completable.isDone();
    }

    @Override
    public boolean isSucceeded() {
        return this.isCompleted() && !this.isFailed();
    }

    @Override
    public boolean isFailed() {
        return this.completable.isCompletedExceptionally();
    }

    @Override
    public void handler(Handler<AsyncResult<T>> completionHandler) {
        Future completion = Future.future();
        completion.setHandler(completionHandler);
        this.resolve(completion);
    }

    @Override
    public void await() {
        try {
            this.completable.get();
        }
        catch (ExecutionException executionException) {
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Helper.uncheckedThrow(e);
        }
    }

    @Override
    public void await(long timeoutMillis) {
        try {
            this.completable.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException executionException) {
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Helper.uncheckedThrow(e);
        }
        catch (TimeoutException e) {
            Helper.uncheckedThrow(new TimeoutException("Timed out"));
        }
    }

    @Override
    public void awaitSuccess() {
        try {
            this.completable.get();
        }
        catch (ExecutionException result) {
            Helper.uncheckedThrow(result.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Helper.uncheckedThrow(e);
        }
    }

    @Override
    public void awaitSuccess(long timeoutMillis) {
        try {
            this.completable.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException result) {
            Helper.uncheckedThrow(result.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Helper.uncheckedThrow(e);
        }
        catch (TimeoutException e) {
            Helper.uncheckedThrow(new TimeoutException("Timed out"));
        }
    }
}

