/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast.util;

import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.ArrayList;
import java.util.List;

public class TextNodeConverter {
    private final BasedSequence nodeChars;
    private BasedSequence remainingChars;
    private ArrayList<Node> list = new ArrayList();

    public TextNodeConverter(BasedSequence nodeChars) {
        this.nodeChars = nodeChars;
        this.remainingChars = nodeChars;
    }

    public void appendChild(Node child) {
        BasedSequence childChars = child.getChars();
        assert (this.nodeChars.containsAllOf(childChars)) : "child " + child.toAstString(false) + " is not within parent sequence " + Node.toSegmentSpan(this.nodeChars, null);
        assert (this.remainingChars.containsAllOf(childChars)) : "child " + child.toAstString(false) + " is not within remaining sequence " + Node.toSegmentSpan(this.remainingChars, null);
        child.unlink();
        if (!(child instanceof Text)) {
            if (this.remainingChars.getStartOffset() < childChars.getStartOffset()) {
                this.list.add(new Text(this.remainingChars.subSequence(0, childChars.getStartOffset() - this.remainingChars.getStartOffset())));
            }
            this.remainingChars = this.remainingChars.subSequence(childChars.getEndOffset() - this.remainingChars.getStartOffset());
            this.list.add(child);
        }
    }

    public void addChildrenOf(Node parent) {
        Node child = parent.getFirstChild();
        while (child != null) {
            Node nextChild = child.getNext();
            this.appendChild(child);
            child = nextChild;
        }
    }

    public void appendMergedTo(Node parent) {
        this.mergeList();
        for (Node child : this.list) {
            parent.appendChild(child);
        }
        this.clear();
    }

    public void clear() {
        this.list.clear();
        this.remainingChars = BasedSequence.NULL;
    }

    public void insertMergedBefore(Node sibling) {
        this.mergeList();
        for (Node node : this.list) {
            sibling.insertBefore(node);
        }
        this.clear();
    }

    public static void mergeTextNodes(Node parent) {
        Node prevNode = null;
        Node child = parent.getFirstChild();
        while (child != null) {
            Node nextChild = child.getNext();
            if (prevNode instanceof Text && child instanceof Text && prevNode.getChars().isContinuedBy(child.getChars())) {
                child.setChars(prevNode.getChars().spliceAtEnd(child.getChars()));
                prevNode.unlink();
            }
            prevNode = child;
            child = nextChild;
        }
    }

    public void insertMergedAfter(Node sibling) {
        this.mergeList();
        for (Node node : this.list) {
            sibling.insertAfter(node);
            sibling = node;
        }
        this.clear();
    }

    private void mergeList() {
        if (!this.remainingChars.isEmpty()) {
            this.list.add(new Text(this.remainingChars));
            this.remainingChars = BasedSequence.NULL;
        }
    }

    public List<Node> getMergedList() {
        this.mergeList();
        return this.list;
    }
}

