/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import io.vertx.ext.web.handler.sockjs.SockJSSocket;
import io.vertx.ext.web.handler.sockjs.impl.BaseTransport;
import io.vertx.ext.web.handler.sockjs.impl.SockJSSession;
import io.vertx.ext.web.handler.sockjs.impl.TransportListener;

class WebSocketTransport
extends BaseTransport {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketTransport.class);

    WebSocketTransport(Vertx vertx, Router router, LocalMap<String, SockJSSession> sessions, SockJSHandlerOptions options, Handler<SockJSSocket> sockHandler) {
        super(vertx, sessions, options);
        String wsRE = "\\/[^\\/\\.]+\\/([^\\/\\.]+)\\/websocket";
        router.getWithRegex(wsRE).handler((Handler<RoutingContext>)((Handler)rc -> {
            HttpServerRequest req = rc.request();
            String connectionHeader = req.headers().get(HttpHeaders.CONNECTION);
            if (connectionHeader == null || !connectionHeader.toLowerCase().contains("upgrade")) {
                rc.response().setStatusCode(400);
                rc.response().end("Can \"Upgrade\" only to \"WebSocket\".");
            } else {
                boolean parseEnded = req.isEnded();
                if (!parseEnded) {
                    req.pause();
                }
                req.toWebSocket(toWebSocket -> {
                    if (toWebSocket.succeeded()) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)"WS, handler");
                        }
                        if (!parseEnded) {
                            req.resume();
                        }
                        SockJSSession session = new SockJSSession(vertx, sessions, (RoutingContext)rc, options, sockHandler);
                        session.register(req, new WebSocketListener((ServerWebSocket)toWebSocket.result(), session));
                    } else {
                        rc.fail(toWebSocket.cause());
                    }
                });
            }
        }));
        router.getWithRegex(wsRE).handler((Handler<RoutingContext>)((Handler)rc -> {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("WS, get: " + rc.request().uri()));
            }
            rc.response().setStatusCode(400);
            rc.response().end("Can \"Upgrade\" only to \"WebSocket\".");
        }));
        router.routeWithRegex(wsRE).handler((Handler<RoutingContext>)((Handler)rc -> {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("WS, all: " + rc.request().uri()));
            }
            rc.response().putHeader(HttpHeaders.ALLOW, (CharSequence)"GET").setStatusCode(405).end();
        }));
    }

    private static class WebSocketListener
    implements TransportListener {
        final ServerWebSocket ws;
        final SockJSSession session;
        boolean closed;

        WebSocketListener(ServerWebSocket ws, SockJSSession session) {
            this.ws = ws;
            this.session = session;
            ws.textMessageHandler(this::handleMessages);
            ws.closeHandler(v -> {
                this.closed = true;
                session.shutdown();
            });
            ws.exceptionHandler(t -> {
                this.closed = true;
                session.shutdown();
                session.handleException((Throwable)t);
            });
        }

        private void handleMessages(String msgs) {
            if (!(this.session.isClosed() || msgs.equals("") || msgs.equals("[]"))) {
                if (msgs.startsWith("[\"") && msgs.endsWith("\"]") || msgs.startsWith("\"") && msgs.endsWith("\"")) {
                    this.session.handleMessages(msgs);
                } else {
                    this.close();
                }
            }
        }

        @Override
        public void sendFrame(String body, Handler<AsyncResult<Void>> handler) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"WS, sending frame");
            }
            if (!this.closed) {
                this.ws.writeTextMessage(body, handler);
            } else if (handler != null) {
                handler.handle((Object)Future.failedFuture((Throwable)ConnectionBase.CLOSED_EXCEPTION));
            }
        }

        @Override
        public void close() {
            if (!this.closed) {
                this.ws.close();
                this.session.shutdown();
                this.closed = true;
            }
        }

        @Override
        public void sessionClosed() {
            this.session.writeClosed(this);
            this.closed = true;
            this.session.context().runOnContext(v -> this.ws.close());
        }
    }
}

