/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.sstore.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.ext.auth.VertxContextPRNG;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.sstore.AbstractSession;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.ext.web.sstore.SessionStore;
import io.vertx.ext.web.sstore.impl.SharedDataSessionImpl;
import java.util.HashSet;

public class LocalSessionStoreImpl
implements SessionStore,
LocalSessionStore,
Handler<Long> {
    private static final long DEFAULT_REAPER_INTERVAL = 1000L;
    private static final String DEFAULT_SESSION_MAP_NAME = "vertx-web.sessions";
    private LocalMap<String, Session> localMap;
    private long reaperInterval;
    private VertxContextPRNG random;
    private long timerID = -1L;
    private boolean closed;
    protected Vertx vertx;

    @Override
    public Session createSession(long timeout) {
        return new SharedDataSessionImpl(this.random, timeout, 16);
    }

    @Override
    public Session createSession(long timeout, int length) {
        return new SharedDataSessionImpl(this.random, timeout, length);
    }

    @Override
    public SessionStore init(Vertx vertx, JsonObject options) {
        this.random = VertxContextPRNG.current((Vertx)vertx);
        this.vertx = vertx;
        this.reaperInterval = options.getLong("reaperInterval", Long.valueOf(1000L));
        this.localMap = vertx.sharedData().getLocalMap(options.getString("mapName", DEFAULT_SESSION_MAP_NAME));
        this.setTimer();
        return this;
    }

    @Override
    public long retryTimeout() {
        return 0L;
    }

    @Override
    public void get(String id, Handler<AsyncResult<Session>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)this.localMap.get((Object)id)));
    }

    @Override
    public void delete(String id, Handler<AsyncResult<Void>> resultHandler) {
        this.localMap.remove((Object)id);
        resultHandler.handle((Object)Future.succeededFuture());
    }

    @Override
    public void put(Session session, Handler<AsyncResult<Void>> resultHandler) {
        AbstractSession oldSession = (AbstractSession)this.localMap.get((Object)session.id());
        AbstractSession newSession = (AbstractSession)session;
        if (oldSession != null && oldSession.version() != newSession.version()) {
            resultHandler.handle((Object)Future.failedFuture((String)"Version mismatch"));
            return;
        }
        newSession.incrementVersion();
        this.localMap.put((Object)session.id(), (Object)session);
        resultHandler.handle((Object)Future.succeededFuture());
    }

    @Override
    public void clear(Handler<AsyncResult<Void>> resultHandler) {
        this.localMap.clear();
        resultHandler.handle((Object)Future.succeededFuture());
    }

    @Override
    public void size(Handler<AsyncResult<Integer>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)this.localMap.size()));
    }

    @Override
    public synchronized void close() {
        this.localMap.close();
        if (this.timerID != -1L) {
            this.vertx.cancelTimer(this.timerID);
        }
        this.closed = true;
    }

    public synchronized void handle(Long tid) {
        long now = System.currentTimeMillis();
        HashSet toRemove = new HashSet();
        this.localMap.forEach((id, session) -> {
            if (now - session.lastAccessed() > session.timeout()) {
                toRemove.add(id);
            }
        });
        for (String id2 : toRemove) {
            this.localMap.remove((Object)id2);
        }
        if (!this.closed) {
            this.setTimer();
        }
    }

    private void setTimer() {
        if (this.reaperInterval != 0L) {
            this.timerID = this.vertx.setTimer(this.reaperInterval, (Handler)this);
        }
    }
}

