/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.AnnotationSubmitter;
import com.github.kristofa.brave.AutoValue_ClientTracer;
import com.github.kristofa.brave.AutoValue_LocalTracer;
import com.github.kristofa.brave.AutoValue_Recorder_Default;
import com.github.kristofa.brave.AutoValue_ServerTracer;
import com.github.kristofa.brave.ClientRequestInterceptor;
import com.github.kristofa.brave.ClientResponseInterceptor;
import com.github.kristofa.brave.ClientSpanThreadBinder;
import com.github.kristofa.brave.ClientTracer;
import com.github.kristofa.brave.InetAddressUtilities;
import com.github.kristofa.brave.InheritableServerClientAndLocalSpanState;
import com.github.kristofa.brave.LocalSpanThreadBinder;
import com.github.kristofa.brave.LocalTracer;
import com.github.kristofa.brave.Recorder;
import com.github.kristofa.brave.Sampler;
import com.github.kristofa.brave.ServerClientAndLocalSpanState;
import com.github.kristofa.brave.ServerRequestInterceptor;
import com.github.kristofa.brave.ServerResponseInterceptor;
import com.github.kristofa.brave.ServerSpanThreadBinder;
import com.github.kristofa.brave.ServerTracer;
import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.SpanCollectorReporterAdapter;
import com.github.kristofa.brave.SpanFactory;
import com.github.kristofa.brave.SpanId;
import com.github.kristofa.brave.ThreadLocalServerClientAndLocalSpanState;
import com.github.kristofa.brave.TraceFilter;
import com.github.kristofa.brave.internal.Internal;
import com.github.kristofa.brave.internal.InternalSpan;
import com.github.kristofa.brave.internal.Nullable;
import com.github.kristofa.brave.internal.Util;
import com.github.kristofa.brave.internal.V2SpanConverter;
import com.twitter.zipkin.gen.Endpoint;
import com.twitter.zipkin.gen.Span;
import java.net.UnknownHostException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import zipkin2.reporter.Reporter;

@Deprecated
public class Brave {
    private final AnnotationSubmitter.Clock clock;
    private final ServerTracer serverTracer;
    private final ClientTracer clientTracer;
    private final LocalTracer localTracer;
    private final ServerRequestInterceptor serverRequestInterceptor;
    private final ServerResponseInterceptor serverResponseInterceptor;
    private final ClientRequestInterceptor clientRequestInterceptor;
    private final ClientResponseInterceptor clientResponseInterceptor;
    private final AnnotationSubmitter serverSpanAnnotationSubmitter;
    private final ServerSpanThreadBinder serverSpanThreadBinder;
    private final ClientSpanThreadBinder clientSpanThreadBinder;
    private final LocalSpanThreadBinder localSpanThreadBinder;

    public AnnotationSubmitter.Clock clock() {
        return this.clock;
    }

    public ClientTracer clientTracer() {
        return this.clientTracer;
    }

    public LocalTracer localTracer() {
        return this.localTracer;
    }

    public ServerTracer serverTracer() {
        return this.serverTracer;
    }

    public ClientRequestInterceptor clientRequestInterceptor() {
        return this.clientRequestInterceptor;
    }

    public ClientResponseInterceptor clientResponseInterceptor() {
        return this.clientResponseInterceptor;
    }

    public ServerRequestInterceptor serverRequestInterceptor() {
        return this.serverRequestInterceptor;
    }

    public ServerResponseInterceptor serverResponseInterceptor() {
        return this.serverResponseInterceptor;
    }

    public ServerSpanThreadBinder serverSpanThreadBinder() {
        return this.serverSpanThreadBinder;
    }

    public ClientSpanThreadBinder clientSpanThreadBinder() {
        return this.clientSpanThreadBinder;
    }

    public LocalSpanThreadBinder localSpanThreadBinder() {
        return this.localSpanThreadBinder;
    }

    @Deprecated
    public AnnotationSubmitter serverSpanAnnotationSubmitter() {
        return this.serverSpanAnnotationSubmitter;
    }

    private Brave(Builder builder) {
        this.clock = builder.clock;
        this.serverSpanThreadBinder = new ServerSpanThreadBinder(builder.state);
        this.clientSpanThreadBinder = new ClientSpanThreadBinder(builder.state);
        this.localSpanThreadBinder = new LocalSpanThreadBinder(builder.state);
        this.serverTracer = new AutoValue_ServerTracer(builder.recorder, this.serverSpanThreadBinder, builder.spanFactory);
        this.clientTracer = new AutoValue_ClientTracer(builder.recorder, this.localSpanThreadBinder, this.serverSpanThreadBinder, this.clientSpanThreadBinder, builder.spanFactory);
        this.localTracer = new AutoValue_LocalTracer.Builder().spanFactory(builder.spanFactory).recorder(builder.recorder).allowNestedLocalSpans(builder.allowNestedLocalSpans).currentServerSpan(this.serverSpanThreadBinder).currentSpan(this.localSpanThreadBinder).build();
        this.serverSpanAnnotationSubmitter = AnnotationSubmitter.create(this.serverSpanThreadBinder, builder.recorder);
        this.serverRequestInterceptor = new ServerRequestInterceptor(this.serverTracer);
        this.serverResponseInterceptor = new ServerResponseInterceptor(this.serverTracer);
        this.clientRequestInterceptor = new ClientRequestInterceptor(this.clientTracer);
        this.clientResponseInterceptor = new ClientResponseInterceptor(this.clientTracer);
    }

    static Span toSpan(SpanId context) {
        return InternalSpan.instance.toSpan(context);
    }

    @Nullable
    static SpanId context(Span span) {
        return InternalSpan.instance.context(span);
    }

    static {
        Internal.instance = new Internal(){

            @Override
            public void setClientAddress(Brave brave, Endpoint ca) {
                Span span = brave.serverSpanThreadBinder().get();
                if (span == null) {
                    return;
                }
                brave.serverTracer.recorder().address(span, "ca", ca);
            }
        };
        new Span();
    }

    static enum LoggingReporter implements Reporter<zipkin2.Span>
    {
        INSTANCE;

        final Logger logger = Logger.getLogger(Brave.class.getName());

        public void report(zipkin2.Span span) {
            if (!this.logger.isLoggable(Level.INFO)) {
                return;
            }
            if (span == null) {
                throw new NullPointerException("span == null");
            }
            this.logger.info(span.toString());
        }

        public String toString() {
            return "LoggingReporter{name=" + this.logger.getName() + "}";
        }
    }

    public static class Builder {
        final Logger logger = Logger.getLogger(Brave.class.getName());
        final SpanFactory.Default.Builder spanFactoryBuilder = SpanFactory.Default.builder();
        private final ServerClientAndLocalSpanState state;
        final Endpoint localEndpoint;
        private boolean allowNestedLocalSpans = false;
        private AnnotationSubmitter.Clock clock;
        private Recorder recorder;
        private SpanFactory spanFactory;
        private Reporter<zipkin2.Span> reporter;

        public Builder() {
            this("unknown");
        }

        public Builder(String serviceName) {
            int ipv4 = 2130706433;
            try {
                ipv4 = InetAddressUtilities.toInt(InetAddressUtilities.getLocalHostLANAddress());
            }
            catch (UnknownHostException e) {
                this.logger.log(Level.WARNING, "Unable to get Inet address", e);
            }
            this.state = new ThreadLocalServerClientAndLocalSpanState(ipv4, 0, serviceName);
            this.localEndpoint = this.state.endpoint();
        }

        public Builder(int ip, int port, String serviceName) {
            this(Endpoint.builder().serviceName(serviceName).ipv4(ip).port(port).build());
        }

        public Builder(Endpoint endpoint) {
            this(new ThreadLocalServerClientAndLocalSpanState(endpoint));
        }

        public Builder(ServerClientAndLocalSpanState state) {
            this.state = Util.checkNotNull(state, "state must be specified.", new Object[0]);
            this.localEndpoint = state.endpoint();
            this.allowNestedLocalSpans = state instanceof InheritableServerClientAndLocalSpanState;
        }

        @Deprecated
        public Builder traceFilters(List<TraceFilter> ignored) {
            return this;
        }

        public Builder traceSampler(Sampler sampler) {
            this.spanFactoryBuilder.sampler(sampler);
            return this;
        }

        public Builder spanReporter(Reporter<zipkin2.Span> reporter) {
            if (reporter == null) {
                throw new NullPointerException("spanReporter == null");
            }
            this.reporter = reporter;
            return this;
        }

        @Deprecated
        public Builder reporter(final zipkin.reporter.Reporter<zipkin.Span> reporter) {
            if (reporter == null) {
                throw new NullPointerException("spanReporter == null");
            }
            if (reporter == zipkin.reporter.Reporter.NOOP) {
                this.reporter = Reporter.NOOP;
                return this;
            }
            this.reporter = new Reporter<zipkin2.Span>(){

                public void report(zipkin2.Span span) {
                    reporter.report((Object)V2SpanConverter.toSpan(span));
                }

                public String toString() {
                    return reporter.toString();
                }
            };
            return this;
        }

        Builder spanFactory(SpanFactory spanFactory) {
            this.spanFactory = spanFactory;
            return this;
        }

        Builder recorder(Recorder recorder) {
            this.recorder = recorder;
            return this;
        }

        @Deprecated
        public Builder spanCollector(SpanCollector spanCollector) {
            return this.spanReporter(new SpanCollectorReporterAdapter(spanCollector));
        }

        public Builder clock(AnnotationSubmitter.Clock clock) {
            if (clock == null) {
                throw new NullPointerException("clock == null");
            }
            this.clock = clock;
            return this;
        }

        public Builder traceId128Bit(boolean traceId128Bit) {
            this.spanFactoryBuilder.traceId128Bit(traceId128Bit);
            return this;
        }

        public Builder supportsJoin(boolean supportsJoin) {
            this.spanFactoryBuilder.supportsJoin(supportsJoin);
            return this;
        }

        public Brave build() {
            if (this.spanFactory == null) {
                this.spanFactory = this.spanFactoryBuilder.build();
            }
            if (this.clock == null) {
                this.clock = new AnnotationSubmitter.DefaultClock();
            }
            if (this.reporter != null) {
                this.recorder = new AutoValue_Recorder_Default(this.localEndpoint, this.clock, this.reporter);
            } else if (this.recorder == null) {
                this.recorder = new AutoValue_Recorder_Default(this.localEndpoint, this.clock, LoggingReporter.INSTANCE);
            }
            return new Brave(this);
        }
    }
}

