/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

public class IdConversion {
    public static String convertToString(long id) {
        return Long.toHexString(id);
    }

    public static long convertToLong(String lowerHex) {
        int length = lowerHex.length();
        if (length < 1 || length > 32) {
            throw IdConversion.isntLowerHexLong(lowerHex);
        }
        int beginIndex = length > 16 ? length - 16 : 0;
        return IdConversion.convertToLong(lowerHex, beginIndex);
    }

    public static long convertToLong(String lowerHex, int index) {
        int endIndex = Math.min(index + 16, lowerHex.length());
        long result = IdConversion.lenientConvertToLong(lowerHex, index, endIndex);
        if (result == 0L) {
            throw IdConversion.isntLowerHexLong(lowerHex);
        }
        return result;
    }

    public static long lenientConvertToLong(String lowerHex, int index, int endIndex) {
        long result = 0L;
        while (index < endIndex) {
            char c = lowerHex.charAt(index++);
            result <<= 4;
            if (c >= '0' && c <= '9') {
                result |= (long)(c - 48);
                continue;
            }
            if (c >= 'a' && c <= 'f') {
                result |= (long)(c - 97 + 10);
                continue;
            }
            return 0L;
        }
        return result;
    }

    static NumberFormatException isntLowerHexLong(String lowerHex) {
        throw new NumberFormatException(lowerHex + " should be a 1 to 32 character lower-hex string with no prefix");
    }
}

