/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.AnnotationSubmitter;
import com.github.kristofa.brave.internal.DefaultSpanCodec;
import com.google.auto.value.AutoValue;
import com.twitter.zipkin.gen.Annotation;
import com.twitter.zipkin.gen.BinaryAnnotation;
import com.twitter.zipkin.gen.Endpoint;
import java.util.List;
import zipkin2.Span;
import zipkin2.reporter.Reporter;
import zipkin2.v1.V1SpanConverter;

abstract class Recorder {
    Recorder() {
    }

    abstract long currentTimeMicroseconds(com.twitter.zipkin.gen.Span var1);

    abstract void name(com.twitter.zipkin.gen.Span var1, String var2);

    abstract void start(com.twitter.zipkin.gen.Span var1, long var2);

    abstract void annotate(com.twitter.zipkin.gen.Span var1, long var2, String var4);

    abstract void address(com.twitter.zipkin.gen.Span var1, String var2, Endpoint var3);

    abstract void tag(com.twitter.zipkin.gen.Span var1, String var2, String var3);

    abstract void finish(com.twitter.zipkin.gen.Span var1, long var2);

    abstract void flush(com.twitter.zipkin.gen.Span var1);

    @AutoValue
    static abstract class Default
    extends Recorder {
        Default() {
        }

        abstract Endpoint localEndpoint();

        abstract AnnotationSubmitter.Clock clock();

        abstract Reporter<Span> reporter();

        @Override
        long currentTimeMicroseconds(com.twitter.zipkin.gen.Span span) {
            return this.clock().currentTimeMicroseconds();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void name(com.twitter.zipkin.gen.Span span, String name) {
            com.twitter.zipkin.gen.Span span2 = span;
            synchronized (span2) {
                span.setName(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void start(com.twitter.zipkin.gen.Span span, long timestamp) {
            com.twitter.zipkin.gen.Span span2 = span;
            synchronized (span2) {
                span.setTimestamp(timestamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void annotate(com.twitter.zipkin.gen.Span span, long timestamp, String value) {
            Annotation annotation = Annotation.create(timestamp, value, this.localEndpoint());
            com.twitter.zipkin.gen.Span span2 = span;
            synchronized (span2) {
                span.addToAnnotations(annotation);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void address(com.twitter.zipkin.gen.Span span, String key, Endpoint endpoint) {
            BinaryAnnotation address = BinaryAnnotation.address(key, endpoint);
            com.twitter.zipkin.gen.Span span2 = span;
            synchronized (span2) {
                span.addToBinary_annotations(address);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void tag(com.twitter.zipkin.gen.Span span, String key, String value) {
            BinaryAnnotation ba = BinaryAnnotation.create(key, value, this.localEndpoint());
            com.twitter.zipkin.gen.Span span2 = span;
            synchronized (span2) {
                span.addToBinary_annotations(ba);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void finish(com.twitter.zipkin.gen.Span span, long timestamp) {
            com.twitter.zipkin.gen.Span span2 = span;
            synchronized (span2) {
                Long startTimestamp = span.getTimestamp();
                if (startTimestamp != null) {
                    span.setDuration(Math.max(1L, timestamp - startTimestamp));
                }
            }
            this.flush(span);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void flush(com.twitter.zipkin.gen.Span span) {
            int i;
            int length;
            com.twitter.zipkin.gen.Span span2 = span;
            synchronized (span2) {
                if (span.isShared()) {
                    length = span.getAnnotations().size();
                    for (i = 0; i < length; ++i) {
                        if (!span.getAnnotations().get((int)i).value.equals("sr")) continue;
                        span.setTimestamp(null);
                        break;
                    }
                }
            }
            List toReport = V1SpanConverter.create().convert(DefaultSpanCodec.toZipkin(span));
            length = toReport.size();
            for (i = 0; i < length; ++i) {
                this.reporter().report((Object)((Span)toReport.get(i)));
            }
        }
    }
}

