/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.AutoValue_SpanFactory_Default;
import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.Sampler;
import com.github.kristofa.brave.SpanId;
import com.github.kristofa.brave.internal.Nullable;
import com.google.auto.value.AutoValue;
import com.twitter.zipkin.gen.Span;
import java.util.Random;

abstract class SpanFactory {
    SpanFactory() {
    }

    abstract Span nextSpan(@Nullable SpanId var1);

    abstract Span joinSpan(SpanId var1);

    static long nextTraceIdHigh(Random prng) {
        long epochSeconds = System.currentTimeMillis() / 1000L;
        int random = prng.nextInt();
        return (epochSeconds & 0xFFFFFFFFL) << 32 | (long)random & 0xFFFFFFFFL;
    }

    @AutoValue
    static abstract class Default
    extends SpanFactory {
        Default() {
        }

        static Builder builder() {
            return new AutoValue_SpanFactory_Default.Builder().traceId128Bit(false).supportsJoin(true).randomGenerator(new Random()).sampler(Sampler.ALWAYS_SAMPLE);
        }

        abstract Builder toBuilder();

        abstract Random randomGenerator();

        abstract boolean traceId128Bit();

        abstract boolean supportsJoin();

        abstract Sampler sampler();

        @Override
        Span nextSpan(@Nullable SpanId maybeParent) {
            long newSpanId = this.randomGenerator().nextLong();
            while (newSpanId == 0L) {
                newSpanId = this.randomGenerator().nextLong();
            }
            if (maybeParent == null) {
                return Brave.toSpan(SpanId.builder().traceIdHigh(this.traceId128Bit() ? Default.nextTraceIdHigh(this.randomGenerator()) : 0L).traceId(newSpanId).spanId(newSpanId).sampled(this.sampler().isSampled(newSpanId)).build());
            }
            return Brave.toSpan(maybeParent.toBuilder().parentId(maybeParent.spanId).spanId(newSpanId).build());
        }

        @Override
        Span joinSpan(SpanId context) {
            if (!this.supportsJoin()) {
                return this.nextSpan(context);
            }
            if (context.sampled() == null) {
                return Brave.toSpan(context.toBuilder().sampled(this.sampler().isSampled(context.traceId)).build());
            }
            if (context.sampled().booleanValue()) {
                return Brave.toSpan(context).setShared();
            }
            return Brave.toSpan(context);
        }

        @AutoValue.Builder
        static interface Builder {
            public Builder randomGenerator(Random var1);

            public Builder traceId128Bit(boolean var1);

            public Builder supportsJoin(boolean var1);

            public Builder sampler(Sampler var1);

            public Default build();
        }
    }
}

