/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import brave.Clock;
import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.internal.Platform;
import brave.propagation.TraceContext;
import brave.sampler.Sampler;
import com.github.kristofa.brave.AnnotationSubmitter;
import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.Recorder;
import com.github.kristofa.brave.ServerClientAndLocalSpanState;
import com.github.kristofa.brave.ServerSpan;
import com.github.kristofa.brave.ServerSpanThreadBinder;
import com.github.kristofa.brave.SpanFactory;
import com.github.kristofa.brave.SpanId;
import com.github.kristofa.brave.ThreadLocalServerClientAndLocalSpanState;
import com.github.kristofa.brave.internal.InternalSpan;
import com.github.kristofa.brave.internal.Nullable;
import com.twitter.zipkin.gen.Endpoint;
import zipkin2.Endpoint;

public final class TracerAdapter {
    static final Endpoint DUMMY_ENDPOINT = Endpoint.builder().serviceName("not used").build();

    public static Brave newBrave(Tracing tracing) {
        if (tracing == null) {
            throw new NullPointerException("tracer == null");
        }
        return TracerAdapter.newBrave(tracing, new ThreadLocalServerClientAndLocalSpanState(DUMMY_ENDPOINT));
    }

    public static Brave newBrave(Tracing tracing, ServerClientAndLocalSpanState state) {
        if (tracing == null) {
            throw new NullPointerException("tracer == null");
        }
        if (state == null) {
            throw new NullPointerException("state == null");
        }
        final Clock delegate = Platform.get().clock();
        return new Brave.Builder(state).clock(new AnnotationSubmitter.Clock(){

            @Override
            public long currentTimeMicroseconds() {
                return delegate.currentTimeMicroseconds();
            }

            public String toString() {
                return delegate.toString();
            }
        }).spanFactory(new Brave4SpanFactory(tracing)).recorder(new Brave4Recorder(tracing)).build();
    }

    public static Span toSpan(Tracer tracer, com.twitter.zipkin.gen.Span span) {
        if (tracer == null) {
            throw new NullPointerException("tracer == null");
        }
        return tracer.toSpan(TracerAdapter.toTraceContext(Brave.context(span)));
    }

    public static Span toSpan(Tracer tracer, SpanId spanId) {
        if (tracer == null) {
            throw new NullPointerException("tracer == null");
        }
        return tracer.toSpan(TracerAdapter.toTraceContext(spanId));
    }

    @Nullable
    public static Span getServerSpan(Tracer tracer, ServerSpanThreadBinder threadBinder) {
        if (tracer == null) {
            throw new NullPointerException("tracer == null");
        }
        if (threadBinder == null) {
            throw new NullPointerException("threadBinder == null");
        }
        ServerSpan result = threadBinder.getCurrentServerSpan();
        if (result == null || result.equals(ServerSpan.EMPTY)) {
            return null;
        }
        if (result.getSpan() != null) {
            return TracerAdapter.toSpan(tracer, result.getSpan());
        }
        assert (result.getSample() != null && !result.getSample().booleanValue()) : "unexpected sample state: " + result;
        return tracer.withSampler(Sampler.NEVER_SAMPLE).newTrace();
    }

    public static void setServerSpan(TraceContext context, ServerSpanThreadBinder threadBinder) {
        if (threadBinder == null) {
            throw new NullPointerException("threadBinder == null");
        }
        ServerSpan serverSpan = ServerSpan.create(TracerAdapter.toSpan(context));
        threadBinder.setCurrentSpan(serverSpan);
    }

    public static TraceContext toTraceContext(SpanId spanId) {
        if (spanId == null) {
            throw new NullPointerException("spanId == null");
        }
        return TraceContext.newBuilder().traceIdHigh(spanId.traceIdHigh).traceId(spanId.traceId).parentId(spanId.nullableParentId()).spanId(spanId.spanId).debug(spanId.debug()).sampled(spanId.sampled()).build();
    }

    public static com.twitter.zipkin.gen.Span toSpan(TraceContext context) {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        return InternalSpan.instance.toSpan(TracerAdapter.toSpanId(context));
    }

    static SpanId toSpanId(TraceContext context) {
        return SpanId.builder().traceIdHigh(context.traceIdHigh()).traceId(context.traceId()).parentId(context.parentId()).spanId(context.spanId()).debug(context.debug()).sampled(context.sampled()).build();
    }

    static final class Brave4Recorder
    extends Recorder {
        final Tracing tracing;
        final Tracer tracer;

        Brave4Recorder(Tracing tracing) {
            this.tracing = tracing;
            this.tracer = tracing.tracer();
        }

        @Override
        void name(com.twitter.zipkin.gen.Span span, String name) {
            this.brave4(span).name(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void start(com.twitter.zipkin.gen.Span span, long timestamp) {
            com.twitter.zipkin.gen.Span span2 = span;
            synchronized (span2) {
                span.setTimestamp(timestamp);
            }
            this.brave4(span).start(timestamp);
        }

        @Override
        void annotate(com.twitter.zipkin.gen.Span span, long timestamp, String value) {
            this.brave4(span).annotate(timestamp, value);
        }

        @Override
        void address(com.twitter.zipkin.gen.Span span, String key, Endpoint endpoint) {
            Span brave4 = this.brave4(span);
            String string = key;
            int n = -1;
            switch (string.hashCode()) {
                case 3662: {
                    if (!string.equals("sa")) break;
                    n = 0;
                    break;
                }
                case 3166: {
                    if (!string.equals("ca")) break;
                    n = 1;
                }
            }
            switch (n) {
                case 0: {
                    brave4.kind(Span.Kind.CLIENT);
                    break;
                }
                case 1: {
                    brave4.kind(Span.Kind.SERVER);
                    break;
                }
                default: {
                    throw new AssertionError((Object)(key + " is not yet supported"));
                }
            }
            Endpoint.Builder endpointBuilder = zipkin2.Endpoint.newBuilder().serviceName(endpoint.service_name).port(endpoint.port != null ? (int)endpoint.port.shortValue() : 0);
            if (endpoint.ipv6 != null) {
                endpointBuilder.parseIp(endpoint.ipv6);
            }
            int ipv4 = endpoint.ipv4;
            if (endpoint.ipv4 != 0) {
                endpointBuilder.parseIp(new byte[]{(byte)(ipv4 >> 24 & 0xFF), (byte)(ipv4 >> 16 & 0xFF), (byte)(ipv4 >> 8 & 0xFF), (byte)(ipv4 & 0xFF)});
            }
            brave4.remoteEndpoint(endpointBuilder.build());
        }

        @Override
        void tag(com.twitter.zipkin.gen.Span span, String key, String value) {
            this.brave4(span).tag(key, value);
        }

        @Override
        void finish(com.twitter.zipkin.gen.Span span, long timestamp) {
            this.brave4(span).finish(timestamp);
        }

        @Override
        void flush(com.twitter.zipkin.gen.Span span) {
            this.brave4(span).flush();
        }

        Span brave4(com.twitter.zipkin.gen.Span span) {
            return this.tracer.toSpan(TracerAdapter.toTraceContext(InternalSpan.instance.context(span)));
        }

        @Override
        long currentTimeMicroseconds(com.twitter.zipkin.gen.Span span) {
            return this.tracing.clock(TracerAdapter.toTraceContext(InternalSpan.instance.context(span))).currentTimeMicroseconds();
        }
    }

    static final class Brave4SpanFactory
    extends SpanFactory {
        final Tracer tracer;

        Brave4SpanFactory(Tracing tracing) {
            this.tracer = tracing.tracer();
        }

        @Override
        com.twitter.zipkin.gen.Span nextSpan(@Nullable SpanId maybeParent) {
            Span span = maybeParent != null ? this.tracer.newChild(TracerAdapter.toTraceContext(maybeParent)) : this.tracer.newTrace();
            return Brave.toSpan(TracerAdapter.toSpanId(span.context()));
        }

        @Override
        com.twitter.zipkin.gen.Span joinSpan(SpanId spanId) {
            TraceContext context = TracerAdapter.toTraceContext(spanId);
            return Brave.toSpan(TracerAdapter.toSpanId(this.tracer.joinSpan(context).context()));
        }
    }
}

