/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.internal;

import com.github.kristofa.brave.SpanId;
import com.github.kristofa.brave.internal.InternalSpan;
import com.github.kristofa.brave.internal.Util;
import com.twitter.zipkin.gen.Annotation;
import com.twitter.zipkin.gen.AnnotationType;
import com.twitter.zipkin.gen.BinaryAnnotation;
import com.twitter.zipkin.gen.Endpoint;
import com.twitter.zipkin.gen.SpanCodec;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import zipkin2.Span;
import zipkin2.codec.SpanBytesDecoder;
import zipkin2.codec.SpanBytesEncoder;
import zipkin2.v1.V1Annotation;
import zipkin2.v1.V1Span;
import zipkin2.v1.V1SpanConverter;
import zipkin2.v1.V2SpanConverter;

public final class DefaultSpanCodec
implements SpanCodec {
    public static final SpanCodec JSON = new DefaultSpanCodec(SpanBytesEncoder.JSON_V1, SpanBytesDecoder.JSON_V1);
    public static final SpanCodec THRIFT = new DefaultSpanCodec(SpanBytesEncoder.THRIFT, SpanBytesDecoder.THRIFT);
    private final SpanBytesEncoder encoder;
    private final SpanBytesDecoder decoder;

    private DefaultSpanCodec(SpanBytesEncoder encoder, SpanBytesDecoder decoder) {
        this.encoder = encoder;
        this.decoder = decoder;
    }

    @Override
    public byte[] writeSpan(com.twitter.zipkin.gen.Span span) {
        V1SpanConverter converter = V1SpanConverter.create();
        List v1Spans = converter.convert(DefaultSpanCodec.toZipkin(span));
        return this.encoder.encode((Object)((Span)v1Spans.get(0)));
    }

    @Override
    public byte[] writeSpans(List<com.twitter.zipkin.gen.Span> spans) {
        V1SpanConverter converter = V1SpanConverter.create();
        ArrayList out = new ArrayList(spans.size());
        for (com.twitter.zipkin.gen.Span span : spans) {
            out.addAll(converter.convert(DefaultSpanCodec.toZipkin(span)));
        }
        return this.encoder.encodeList(out);
    }

    @Override
    public com.twitter.zipkin.gen.Span readSpan(byte[] bytes) {
        return DefaultSpanCodec.fromZipkin((Span)this.decoder.decodeOne(bytes));
    }

    public static com.twitter.zipkin.gen.Span fromZipkin(Span v2) {
        V1Span in = V2SpanConverter.create().convert(v2);
        com.twitter.zipkin.gen.Span result = DefaultSpanCodec.newSpan(SpanId.builder().traceIdHigh(in.traceIdHigh()).traceId(in.traceId()).spanId(in.id()).parentId(in.parentId() != 0L ? Long.valueOf(in.parentId()) : null).debug(in.debug() != null ? in.debug() : false).build());
        result.setName(in.name());
        result.setTimestamp(in.timestamp() != 0L ? Long.valueOf(in.timestamp()) : null);
        result.setDuration(in.duration() != 0L ? Long.valueOf(in.duration()) : null);
        for (V1Annotation a : in.annotations()) {
            result.addToAnnotations(Annotation.create(a.timestamp(), a.value(), DefaultSpanCodec.to(a.endpoint())));
        }
        for (V1Annotation a : in.binaryAnnotations()) {
            byte[] byArray;
            if (a.type() != 0 && a.type() != 6) continue;
            String string = a.key();
            if (a.type() == 0) {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = 1;
            } else {
                byArray = a.stringValue().getBytes(Util.UTF_8);
            }
            result.addToBinary_annotations(BinaryAnnotation.create(string, byArray, a.type() == 0 ? AnnotationType.BOOL : AnnotationType.STRING, DefaultSpanCodec.to(a.endpoint())));
        }
        return result;
    }

    private static Endpoint to(zipkin2.Endpoint host) {
        if (host == null) {
            return null;
        }
        byte[] ipv4 = host.ipv4Bytes();
        return Endpoint.builder().ipv4(ipv4 != null ? ByteBuffer.wrap(ipv4).getInt() : 0).ipv6(host.ipv6Bytes()).port(host.portAsInt()).serviceName(host.serviceName()).build();
    }

    public static V1Span toZipkin(com.twitter.zipkin.gen.Span span) {
        V1Span.Builder result = V1Span.newBuilder();
        result.traceId(span.getTrace_id());
        result.traceIdHigh(span.getTrace_id_high());
        result.id(span.getId());
        result.parentId(span.getParent_id() != null ? span.getParent_id() : 0L);
        result.name(span.getName());
        result.timestamp(span.getTimestamp() != null ? span.getTimestamp() : 0L);
        result.duration(span.getDuration() != null ? span.getDuration() : 0L);
        result.debug(span.isDebug());
        for (Annotation annotation : span.getAnnotations()) {
            result.addAnnotation(annotation.timestamp, annotation.value, annotation.host != null ? annotation.host.toV2() : null);
        }
        for (BinaryAnnotation binaryAnnotation : span.getBinary_annotations()) {
            zipkin2.Endpoint endpoint;
            zipkin2.Endpoint endpoint2 = endpoint = binaryAnnotation.host != null ? binaryAnnotation.host.toV2() : null;
            if (binaryAnnotation.type == AnnotationType.STRING) {
                result.addBinaryAnnotation(binaryAnnotation.key, new String(binaryAnnotation.value, Util.UTF_8), endpoint);
                continue;
            }
            if (binaryAnnotation.type != AnnotationType.BOOL || endpoint == null) continue;
            result.addBinaryAnnotation(binaryAnnotation.key, endpoint);
        }
        return result.build();
    }

    static com.twitter.zipkin.gen.Span newSpan(SpanId context) {
        return InternalSpan.instance.toSpan(context);
    }
}

