/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.internal;

import com.github.kristofa.brave.IdConversion;
import java.util.Map;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.Endpoint;
import zipkin.Span;
import zipkin2.Endpoint;
import zipkin2.Span;

public final class V2SpanConverter {
    public static zipkin.Span toSpan(Span in) {
        String traceId = in.traceId();
        Span.Builder result = zipkin.Span.builder().traceId(IdConversion.convertToLong(traceId)).parentId(in.parentId() != null ? Long.valueOf(IdConversion.convertToLong(in.parentId())) : null).id(IdConversion.convertToLong(in.id())).debug(in.debug()).name(in.name() != null ? in.name() : "");
        if (traceId.length() == 32) {
            result.traceIdHigh(IdConversion.convertToLong(traceId, 0));
        }
        long startTs = in.timestamp() == null ? 0L : in.timestamp();
        Long endTs = in.duration() == null ? 0L : in.timestamp() + in.duration();
        if (startTs != 0L) {
            result.timestamp(Long.valueOf(startTs));
            result.duration(in.duration());
        }
        zipkin.Endpoint local = in.localEndpoint() != null ? V2SpanConverter.toEndpoint(in.localEndpoint()) : null;
        zipkin.Endpoint remote = in.remoteEndpoint() != null ? V2SpanConverter.toEndpoint(in.remoteEndpoint()) : null;
        Span.Kind kind = in.kind();
        Annotation cs = null;
        Annotation sr = null;
        Annotation ss = null;
        Annotation cr = null;
        Annotation ms = null;
        Annotation mr = null;
        Annotation ws = null;
        Annotation wr = null;
        String remoteEndpointType = null;
        boolean wroteEndpoint = false;
        int length = in.annotations().size();
        for (int i = 0; i < length; ++i) {
            zipkin2.Annotation input = (zipkin2.Annotation)in.annotations().get(i);
            Annotation a = Annotation.create((long)input.timestamp(), (String)input.value(), (zipkin.Endpoint)local);
            if (a.value.length() == 2) {
                if (a.value.equals("cs")) {
                    kind = Span.Kind.CLIENT;
                    cs = a;
                    remoteEndpointType = "sa";
                    continue;
                }
                if (a.value.equals("sr")) {
                    kind = Span.Kind.SERVER;
                    sr = a;
                    remoteEndpointType = "ca";
                    continue;
                }
                if (a.value.equals("ss")) {
                    kind = Span.Kind.SERVER;
                    ss = a;
                    continue;
                }
                if (a.value.equals("cr")) {
                    kind = Span.Kind.CLIENT;
                    cr = a;
                    continue;
                }
                if (a.value.equals("ms")) {
                    kind = Span.Kind.PRODUCER;
                    ms = a;
                    continue;
                }
                if (a.value.equals("mr")) {
                    kind = Span.Kind.CONSUMER;
                    mr = a;
                    continue;
                }
                if (a.value.equals("ws")) {
                    ws = a;
                    continue;
                }
                if (a.value.equals("wr")) {
                    wr = a;
                    continue;
                }
                wroteEndpoint = true;
                result.addAnnotation(a);
                continue;
            }
            wroteEndpoint = true;
            result.addAnnotation(a);
        }
        if (kind != null) {
            switch (kind) {
                case CLIENT: {
                    remoteEndpointType = "sa";
                    if (startTs != 0L) {
                        cs = Annotation.create((long)startTs, (String)"cs", (zipkin.Endpoint)local);
                    }
                    if (endTs == 0L) break;
                    cr = Annotation.create((long)endTs, (String)"cr", (zipkin.Endpoint)local);
                    break;
                }
                case SERVER: {
                    remoteEndpointType = "ca";
                    if (startTs != 0L) {
                        sr = Annotation.create((long)startTs, (String)"sr", (zipkin.Endpoint)local);
                    }
                    if (endTs == 0L) break;
                    ss = Annotation.create((long)endTs, (String)"ss", (zipkin.Endpoint)local);
                    break;
                }
                case PRODUCER: {
                    remoteEndpointType = "ma";
                    if (startTs != 0L) {
                        ms = Annotation.create((long)startTs, (String)"ms", (zipkin.Endpoint)local);
                    }
                    if (endTs == 0L) break;
                    ws = Annotation.create((long)endTs, (String)"ws", (zipkin.Endpoint)local);
                    break;
                }
                case CONSUMER: {
                    remoteEndpointType = "ma";
                    if (startTs != 0L && endTs != 0L) {
                        wr = Annotation.create((long)startTs, (String)"wr", (zipkin.Endpoint)local);
                        mr = Annotation.create((long)endTs, (String)"mr", (zipkin.Endpoint)local);
                        break;
                    }
                    if (startTs == 0L) break;
                    mr = Annotation.create((long)startTs, (String)"mr", (zipkin.Endpoint)local);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"update kind mapping");
                }
            }
        }
        for (Map.Entry tag : in.tags().entrySet()) {
            wroteEndpoint = true;
            result.addBinaryAnnotation(BinaryAnnotation.create((String)((String)tag.getKey()), (String)((String)tag.getValue()), (zipkin.Endpoint)local));
        }
        if (cs != null || sr != null || ss != null || cr != null || ws != null || wr != null || ms != null || mr != null) {
            if (cs != null) {
                result.addAnnotation(cs);
            }
            if (sr != null) {
                result.addAnnotation(sr);
            }
            if (ss != null) {
                result.addAnnotation(ss);
            }
            if (cr != null) {
                result.addAnnotation(cr);
            }
            if (ws != null) {
                result.addAnnotation(ws);
            }
            if (wr != null) {
                result.addAnnotation(wr);
            }
            if (ms != null) {
                result.addAnnotation(ms);
            }
            if (mr != null) {
                result.addAnnotation(mr);
            }
            wroteEndpoint = true;
        } else if (local != null && remote != null) {
            result.addBinaryAnnotation(BinaryAnnotation.address((String)"ca", (zipkin.Endpoint)local));
            wroteEndpoint = true;
            remoteEndpointType = "sa";
        }
        if (remoteEndpointType != null && remote != null) {
            result.addBinaryAnnotation(BinaryAnnotation.address((String)remoteEndpointType, (zipkin.Endpoint)remote));
        }
        if (Boolean.TRUE.equals(in.shared()) && sr != null) {
            result.timestamp(null).duration(null);
        }
        if (local != null && !wroteEndpoint) {
            result.addBinaryAnnotation(BinaryAnnotation.create((String)"lc", (String)"", (zipkin.Endpoint)local));
        }
        return result.build();
    }

    static zipkin.Endpoint toEndpoint(Endpoint input) {
        Endpoint.Builder result = zipkin.Endpoint.builder().serviceName(input.serviceName() != null ? input.serviceName() : "").port(input.port() != null ? input.port() : 0);
        if (input.ipv6() != null) {
            result.parseIp(input.ipv6());
        }
        if (input.ipv4() != null) {
            result.parseIp(input.ipv4());
        }
        return result.build();
    }
}

