/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.zipkin.gen;

import com.github.kristofa.brave.internal.Nullable;
import com.github.kristofa.brave.internal.Util;
import java.io.Serializable;
import java.util.Arrays;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.codec.SpanBytesEncoder;

public class Endpoint
implements Serializable {
    static final long serialVersionUID = 1L;
    public final int ipv4;
    @Nullable
    public final byte[] ipv6;
    @Nullable
    public final Short port;
    public final String service_name;

    @Deprecated
    public static Endpoint create(String serviceName, int ipv4, int port) {
        return new Endpoint(serviceName, ipv4, null, port == 0 ? null : Short.valueOf((short)(port & 0xFFFF)));
    }

    public static Endpoint create(String serviceName, int ipv4) {
        return new Endpoint(serviceName, ipv4, null, null);
    }

    Endpoint(String service_name, int ipv4, byte[] ipv6, Short port) {
        this.ipv4 = ipv4;
        this.ipv6 = ipv6;
        this.port = port;
        service_name = service_name != null ? service_name.toLowerCase() : "";
        this.service_name = service_name;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Endpoint) {
            Endpoint that = (Endpoint)o;
            return Util.equal(this.service_name, that.service_name) && this.ipv4 == that.ipv4 && Arrays.equals(this.ipv6, that.ipv6) && Util.equal(this.port, that.port);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.service_name.hashCode();
        h *= 1000003;
        h ^= this.ipv4;
        h *= 1000003;
        h ^= Arrays.hashCode(this.ipv6);
        h *= 1000003;
        return h ^= this.port == null ? 0 : this.port.hashCode();
    }

    public String toString() {
        Span fake = Span.newBuilder().traceId(0L, 1L).id(1L).localEndpoint(this.toV2()).build();
        String jsonSpan = new String(SpanBytesEncoder.JSON_V2.encode((Object)fake), Util.UTF_8);
        return jsonSpan.substring(70, jsonSpan.length() - 1);
    }

    public zipkin2.Endpoint toV2() {
        Endpoint.Builder result = zipkin2.Endpoint.newBuilder().serviceName(this.service_name).port(this.port != null ? (int)this.port.shortValue() : 0);
        if (this.ipv4 != 0) {
            result.parseIp(new byte[]{(byte)(this.ipv4 >> 24 & 0xFF), (byte)(this.ipv4 >> 16 & 0xFF), (byte)(this.ipv4 >> 8 & 0xFF), (byte)(this.ipv4 & 0xFF)});
        }
        result.parseIp(this.ipv6);
        return result.build();
    }

    public static final class Builder {
        private String serviceName;
        private Integer ipv4;
        private byte[] ipv6;
        private Short port;

        Builder() {
        }

        Builder(Endpoint source) {
            this.serviceName = source.service_name;
            this.ipv4 = source.ipv4;
            this.ipv6 = source.ipv6;
            this.port = source.port;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder ipv4(int ipv4) {
            this.ipv4 = ipv4;
            return this;
        }

        public Builder ipv6(byte[] ipv6) {
            if (ipv6 != null) {
                if (ipv6.length != 16) {
                    throw new IllegalArgumentException("ipv6.length != 16");
                }
                this.ipv6 = ipv6;
            }
            return this;
        }

        public Builder port(int port) {
            if (port < 0 || port > 65535) {
                throw new IllegalArgumentException("invalid port " + port);
            }
            this.port = port == 0 ? null : Short.valueOf((short)(port & 0xFFFF));
            return this;
        }

        public Builder port(Short port) {
            if (port == null || port != 0) {
                this.port = port;
            }
            return this;
        }

        public Endpoint build() {
            Util.checkNotNull(this.serviceName, "serviceName", new Object[0]);
            return new Endpoint(this.serviceName, this.ipv4 == null ? 0 : this.ipv4, this.ipv6, this.port);
        }
    }
}

