/*
 * Decompiled with CFR 0.152.
 */
package brave.test.http;

import brave.Tracer;
import brave.Tracing;
import brave.http.HttpTracing;
import brave.propagation.B3Propagation;
import brave.propagation.CurrentTraceContext;
import brave.propagation.ExtraFieldPropagation;
import brave.propagation.Propagation;
import brave.propagation.StrictScopeDecorator;
import brave.propagation.ThreadLocalCurrentTraceContext;
import brave.sampler.Sampler;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.After;
import org.junit.Rule;
import org.junit.rules.DisableOnDebug;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.rules.Timeout;
import org.junit.runner.Description;
import zipkin2.Span;

public abstract class ITHttp {
    @Rule
    public TestRule globalTimeout = new DisableOnDebug((TestRule)Timeout.seconds((long)5L));
    @Rule
    public TestName testName = new TestName();
    public static final String EXTRA_KEY = "user-id";
    BlockingQueue<Span> spans = new LinkedBlockingQueue<Span>();
    protected CurrentTraceContext currentTraceContext = ThreadLocalCurrentTraceContext.newBuilder().addScopeDecorator(StrictScopeDecorator.create()).build();
    protected HttpTracing httpTracing;
    @Rule
    public TestRule assertSpansEmpty = new TestWatcher(){

        protected void succeeded(Description description) {
            try {
                ((ObjectAssert)Assertions.assertThat((Object)ITHttp.this.spans.poll(100L, TimeUnit.MILLISECONDS)).withFailMessage("Span remaining in queue. Check for redundant reporting", new Object[0])).isNull();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new AssertionError((Object)e);
            }
        }
    };

    protected Span takeSpan() throws InterruptedException {
        Span result = this.spans.poll(3L, TimeUnit.SECONDS);
        ((ObjectAssert)Assertions.assertThat((Object)result).withFailMessage("Span was not reported", new Object[0])).isNotNull();
        return result;
    }

    protected Tracer tracer() {
        return this.httpTracing.tracing().tracer();
    }

    @After
    public void close() throws Exception {
        Tracing current = Tracing.current();
        if (current != null) {
            current.close();
        }
    }

    protected Tracing.Builder tracingBuilder(Sampler sampler) {
        return Tracing.newBuilder().spanReporter(this.spans::add).propagationFactory((Propagation.Factory)ExtraFieldPropagation.newFactory((Propagation.Factory)B3Propagation.FACTORY, (String[])new String[]{EXTRA_KEY})).currentTraceContext(this.currentTraceContext).sampler(sampler);
    }
}

