/*
 * Decompiled with CFR 0.152.
 */
package brave.test.http;

import brave.ScopedSpan;
import brave.Tracer;
import brave.propagation.TraceContext;
import brave.test.http.ITHttpClient;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.RecordedRequest;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;
import zipkin2.Callback;
import zipkin2.Span;

public abstract class ITHttpAsyncClient<C>
extends ITHttpClient<C> {
    static final Callback<Integer> LOG_ON_ERROR_CALLBACK = new Callback<Integer>(){

        public void onSuccess(Integer statusCode) {
        }

        public void onError(Throwable throwable) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Unexpected error", throwable);
        }
    };
    Object nullSentinel = new Object();

    protected abstract void getAsync(C var1, String var2, Callback<Integer> var3) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void usesParentFromInvocationTime() throws Exception {
        Tracer tracer = this.httpTracing.tracing().tracer();
        this.server.enqueue(new MockResponse().setBodyDelay(300L, TimeUnit.MILLISECONDS));
        this.server.enqueue(new MockResponse());
        ScopedSpan parent = tracer.startScopedSpan("test");
        try {
            this.getAsync(this.client, "/items/1", LOG_ON_ERROR_CALLBACK);
            this.getAsync(this.client, "/items/2", LOG_ON_ERROR_CALLBACK);
        }
        finally {
            parent.finish();
        }
        ScopedSpan otherSpan = tracer.startScopedSpan("test2");
        try {
            for (int i = 0; i < 2; ++i) {
                RecordedRequest request = this.takeRequest();
                Assertions.assertThat((String)request.getHeader("x-b3-traceId")).isEqualTo(parent.context().traceIdString());
                Assertions.assertThat((String)request.getHeader("x-b3-parentspanid")).isEqualTo(parent.context().spanIdString());
            }
        }
        finally {
            otherSpan.finish();
        }
        Assertions.assertThat(Arrays.asList(this.takeSpan(), this.takeSpan(), this.takeSpan(), this.takeSpan())).extracting(Span::kind).containsOnly((Object[])new Span.Kind[]{null, Span.Kind.CLIENT});
    }

    @Test
    public void callbackContextIsFromInvocationTime() throws Exception {
        final LinkedBlockingQueue result = new LinkedBlockingQueue();
        this.server.enqueue(new MockResponse());
        ScopedSpan parent = this.tracer().startScopedSpan("test");
        try {
            this.getAsync(this.client, "/foo", new Callback<Integer>(){

                public void onSuccess(Integer statusCode) {
                    result.add(ITHttpAsyncClient.this.currentTraceContext.get());
                }

                public void onError(Throwable throwable) {
                    result.add(throwable);
                }
            });
        }
        finally {
            parent.finish();
        }
        this.takeRequest();
        ((ObjectAssert)Assertions.assertThat(result.poll(1L, TimeUnit.SECONDS)).isInstanceOf(TraceContext.class)).isSameAs((Object)parent.context());
        Assertions.assertThat(Arrays.asList(this.takeSpan(), this.takeSpan())).extracting(Span::kind).containsOnly((Object[])new Span.Kind[]{null, Span.Kind.CLIENT});
    }

    @Test
    public void callbackContextIsFromInvocationTime_root() throws Exception {
        final LinkedBlockingQueue result = new LinkedBlockingQueue();
        this.server.enqueue(new MockResponse());
        this.getAsync(this.client, "/foo", new Callback<Integer>(){

            public void onSuccess(Integer statusCode) {
                TraceContext context = ITHttpAsyncClient.this.currentTraceContext.get();
                result.add(context != null ? context : ITHttpAsyncClient.this.nullSentinel);
            }

            public void onError(Throwable throwable) {
                result.add(throwable);
            }
        });
        this.takeRequest();
        Assertions.assertThat(result.poll(1L, TimeUnit.SECONDS)).isSameAs(this.nullSentinel);
        Assertions.assertThat((Comparable)this.takeSpan().kind()).isEqualTo((Object)Span.Kind.CLIENT);
    }

    @Test
    public void addsStatusCodeWhenNotOk_async() throws Exception {
        final LinkedBlockingQueue result = new LinkedBlockingQueue();
        int expectedStatusCode = 400;
        this.server.enqueue(new MockResponse().setResponseCode(expectedStatusCode));
        this.getAsync(this.client, "/foo", new Callback<Integer>(){

            public void onSuccess(Integer statusCode) {
                result.add(statusCode != null ? statusCode : ITHttpAsyncClient.this.nullSentinel);
            }

            public void onError(Throwable throwable) {
                result.add(throwable);
            }
        });
        this.takeRequest();
        Object object = result.poll(1L, TimeUnit.SECONDS);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat(object).isInstanceOf(Integer.class)).isNotSameAs(this.nullSentinel)).isEqualTo((Object)expectedStatusCode);
        String expectedStatusCodeString = String.valueOf(expectedStatusCode);
        Span span = this.takeSpan();
        ((MapAssert)Assertions.assertThat((Map)span.tags()).containsEntry((Object)"http.status_code", (Object)expectedStatusCodeString)).containsEntry((Object)"error", (Object)expectedStatusCodeString);
    }
}

