/*
 * Decompiled with CFR 0.152.
 */
package brave.test.http;

import brave.ScopedSpan;
import brave.Span;
import brave.SpanCustomizer;
import brave.Tracer;
import brave.Tracing;
import brave.handler.FinishedSpanHandler;
import brave.handler.MutableSpan;
import brave.http.HttpAdapter;
import brave.http.HttpClientParser;
import brave.http.HttpRequestMatchers;
import brave.http.HttpResponseParser;
import brave.http.HttpRuleSampler;
import brave.http.HttpTracing;
import brave.propagation.ExtraFieldPropagation;
import brave.propagation.TraceContext;
import brave.sampler.Sampler;
import brave.sampler.SamplerFunction;
import brave.sampler.SamplerFunctions;
import brave.test.http.ITHttp;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import okhttp3.mockwebserver.SocketPolicy;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import zipkin2.Endpoint;
import zipkin2.Span;

public abstract class ITHttpClient<C>
extends ITHttp {
    @Rule
    public MockWebServer server = new MockWebServer();
    protected C client;

    @Before
    public void setup() {
        this.httpTracing = HttpTracing.create((Tracing)this.tracingBuilder(Sampler.ALWAYS_SAMPLE).build());
        this.client = this.newClient(this.server.getPort());
    }

    protected abstract C newClient(int var1);

    protected abstract void closeClient(C var1) throws Exception;

    protected abstract void get(C var1, String var2) throws Exception;

    protected abstract void post(C var1, String var2, String var3) throws Exception;

    @Override
    @After
    public void close() throws Exception {
        this.closeClient(this.client);
        super.close();
    }

    @Test
    public void propagatesSpan() throws Exception {
        this.server.enqueue(new MockResponse());
        this.get(this.client, "/foo");
        RecordedRequest request = this.takeRequest();
        Assertions.assertThat((Map)request.getHeaders().toMultimap()).containsKeys((Object[])new String[]{"x-b3-traceId", "x-b3-spanId"}).containsEntry((Object)"x-b3-sampled", Arrays.asList("1"));
        this.takeSpan();
    }

    @Test
    public void makesChildOfCurrentSpan() throws Exception {
        Tracer tracer = this.httpTracing.tracing().tracer();
        this.server.enqueue(new MockResponse());
        ScopedSpan parent = tracer.startScopedSpan("test");
        try {
            this.get(this.client, "/foo");
        }
        finally {
            parent.finish();
        }
        RecordedRequest request = this.takeRequest();
        Assertions.assertThat((String)request.getHeader("x-b3-traceId")).isEqualTo(parent.context().traceIdString());
        Assertions.assertThat((String)request.getHeader("x-b3-parentspanid")).isEqualTo(parent.context().spanIdString());
        Assertions.assertThat(Arrays.asList(this.takeSpan(), this.takeSpan())).extracting(zipkin2.Span::kind).containsOnly((Object[])new Span.Kind[]{null, Span.Kind.CLIENT});
    }

    @Test
    public void propagatesExtra_newTrace() throws Exception {
        Tracer tracer = this.httpTracing.tracing().tracer();
        this.server.enqueue(new MockResponse());
        ScopedSpan parent = tracer.startScopedSpan("test");
        try {
            ExtraFieldPropagation.set((TraceContext)parent.context(), (String)"user-id", (String)"joey");
            this.get(this.client, "/foo");
        }
        finally {
            parent.finish();
        }
        Assertions.assertThat((String)this.takeRequest().getHeader("user-id")).isEqualTo("joey");
        Assertions.assertThat(Arrays.asList(this.takeSpan(), this.takeSpan())).extracting(zipkin2.Span::kind).containsOnly((Object[])new Span.Kind[]{null, Span.Kind.CLIENT});
    }

    @Test
    public void propagatesExtra_unsampledTrace() throws Exception {
        this.server.enqueue(new MockResponse());
        ScopedSpan parent = this.tracer().startScopedSpan("test", SamplerFunctions.neverSample(), (Object)false);
        try {
            ExtraFieldPropagation.set((TraceContext)parent.context(), (String)"user-id", (String)"joey");
            this.get(this.client, "/foo");
        }
        finally {
            parent.finish();
        }
        Assertions.assertThat((String)this.takeRequest().getHeader("user-id")).isEqualTo("joey");
    }

    @Test
    public void propagates_sampledFalse() throws Exception {
        this.close();
        this.httpTracing = HttpTracing.create((Tracing)this.tracingBuilder(Sampler.NEVER_SAMPLE).build());
        this.client = this.newClient(this.server.getPort());
        this.server.enqueue(new MockResponse());
        this.get(this.client, "/foo");
        RecordedRequest request = this.takeRequest();
        ((MapAssert)Assertions.assertThat((Map)request.getHeaders().toMultimap()).containsKeys((Object[])new String[]{"x-b3-traceId", "x-b3-spanId"}).doesNotContainKey((Object)"x-b3-parentSpanId")).containsEntry((Object)"x-b3-sampled", Arrays.asList("0"));
    }

    @Test
    public void customSampler() throws Exception {
        String path = "/foo";
        this.close();
        HttpRuleSampler sampler = HttpRuleSampler.newBuilder().putRule(HttpRequestMatchers.pathStartsWith((String)path), Sampler.NEVER_SAMPLE).build();
        this.httpTracing = this.httpTracing.toBuilder().clientSampler((SamplerFunction)sampler).build();
        this.client = this.newClient(this.server.getPort());
        this.server.enqueue(new MockResponse());
        this.get(this.client, path);
        RecordedRequest request = this.takeRequest();
        Assertions.assertThat((Map)request.getHeaders().toMultimap()).containsEntry((Object)"x-b3-sampled", Arrays.asList("0"));
    }

    @Test
    public void reportsClientKindToZipkin() throws Exception {
        this.server.enqueue(new MockResponse());
        this.get(this.client, "/foo");
        zipkin2.Span span = this.takeSpan();
        Assertions.assertThat((Comparable)span.kind()).isEqualTo((Object)Span.Kind.CLIENT);
    }

    @Test
    public void reportsServerAddress() throws Exception {
        this.server.enqueue(new MockResponse());
        this.get(this.client, "/foo");
        zipkin2.Span span = this.takeSpan();
        Assertions.assertThat((Object)span.remoteEndpoint()).isEqualTo((Object)Endpoint.newBuilder().ip("127.0.0.1").port(this.server.getPort()).build());
    }

    @Test
    public void defaultSpanNameIsMethodName() throws Exception {
        this.server.enqueue(new MockResponse());
        this.get(this.client, "/foo");
        zipkin2.Span span = this.takeSpan();
        Assertions.assertThat((String)span.name()).isEqualTo("get");
    }

    @Test
    public void readsRequestAtResponseTime() throws Exception {
        String uri = "/foo/bar?z=2&yAA=1";
        this.close();
        this.httpTracing = this.httpTracing.toBuilder().clientResponseParser((response, context, span) -> span.tag("http.url", response.request().url())).build();
        this.client = this.newClient(this.server.getPort());
        this.server.enqueue(new MockResponse());
        this.get(this.client, uri);
        Assertions.assertThat((Map)this.takeSpan().tags()).containsEntry((Object)"http.url", (Object)this.url(uri));
    }

    @Test
    public void supportsPortableCustomization() throws Exception {
        String uri = "/foo/bar?z=2&yAA=1";
        this.close();
        this.httpTracing = this.httpTracing.toBuilder().clientRequestParser((request, context, span) -> {
            span.name(request.method().toLowerCase() + " " + request.path());
            span.tag("http.url", request.url());
            span.tag("request_customizer.is_span", (span instanceof Span) + "");
        }).clientResponseParser((response, context, span) -> {
            HttpResponseParser.DEFAULT.parse(response, context, span);
            span.tag("response_customizer.is_span", (span instanceof Span) + "");
        }).build().clientOf("remote-service");
        this.client = this.newClient(this.server.getPort());
        this.server.enqueue(new MockResponse());
        this.get(this.client, uri);
        zipkin2.Span span2 = this.takeSpan();
        Assertions.assertThat((String)span2.name()).isEqualTo("get /foo/bar");
        Assertions.assertThat((String)span2.remoteServiceName()).isEqualTo("remote-service");
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)span2.tags()).containsEntry((Object)"http.url", (Object)this.url(uri))).containsEntry((Object)"request_customizer.is_span", (Object)"false")).containsEntry((Object)"response_customizer.is_span", (Object)"false");
    }

    @Deprecated
    @Test
    public void supportsDeprecatedPortableCustomization() throws Exception {
        String uri = "/foo/bar?z=2&yAA=1";
        this.close();
        this.httpTracing = this.httpTracing.toBuilder().clientParser(new HttpClientParser(){

            public <Req> void request(HttpAdapter<Req, ?> adapter, Req req, SpanCustomizer customizer) {
                customizer.name(adapter.method(req).toLowerCase() + " " + adapter.path(req));
                customizer.tag("http.url", adapter.url(req));
                customizer.tag("context.visible", String.valueOf(ITHttpClient.this.currentTraceContext.get() != null));
                customizer.tag("request_customizer.is_span", (customizer instanceof Span) + "");
            }

            public <Resp> void response(HttpAdapter<?, Resp> adapter, Resp res, Throwable error, SpanCustomizer customizer) {
                super.response(adapter, res, error, customizer);
                customizer.tag("response_customizer.is_span", (customizer instanceof Span) + "");
            }
        }).build().clientOf("remote-service");
        this.client = this.newClient(this.server.getPort());
        this.server.enqueue(new MockResponse());
        this.get(this.client, uri);
        zipkin2.Span span = this.takeSpan();
        Assertions.assertThat((String)span.name()).isEqualTo("get /foo/bar");
        Assertions.assertThat((String)span.remoteServiceName()).isEqualTo("remote-service");
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)span.tags()).containsEntry((Object)"http.url", (Object)this.url(uri))).containsEntry((Object)"context.visible", (Object)"true")).containsEntry((Object)"request_customizer.is_span", (Object)"false")).containsEntry((Object)"response_customizer.is_span", (Object)"false");
    }

    @Test
    public void addsStatusCodeWhenNotOk() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(400));
        try {
            this.get(this.client, "/foo");
        }
        catch (Exception exception) {
            // empty catch block
        }
        zipkin2.Span span = this.takeSpan();
        ((MapAssert)Assertions.assertThat((Map)span.tags()).containsEntry((Object)"http.status_code", (Object)"400")).containsEntry((Object)"error", (Object)"400");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void redirect() throws Exception {
        Tracer tracer = this.httpTracing.tracing().tracer();
        this.server.enqueue(new MockResponse().setResponseCode(302).addHeader("Location: " + this.url("/bar")));
        this.server.enqueue(new MockResponse().setResponseCode(404));
        ScopedSpan parent = tracer.startScopedSpan("test");
        try {
            this.get(this.client, "/foo");
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            parent.finish();
        }
        zipkin2.Span client1 = this.takeSpan();
        zipkin2.Span client2 = this.takeSpan();
        Assertions.assertThat(Arrays.asList((String)client1.tags().get("http.path"), (String)client2.tags().get("http.path"))).contains((Object[])new String[]{"/foo", "/bar"});
        Assertions.assertThat((Comparable)this.takeSpan().kind()).isNull();
    }

    @Test
    public void post() throws Exception {
        String path = "/post";
        String body = "body";
        this.server.enqueue(new MockResponse());
        this.post(this.client, path, body);
        Assertions.assertThat((String)this.takeRequest().getBody().readUtf8()).isEqualTo(body);
        zipkin2.Span span = this.takeSpan();
        Assertions.assertThat((String)span.name()).isEqualTo("post");
    }

    @Test
    public void httpPathTagExcludesQueryParams() throws Exception {
        String path = "/foo?z=2&yAA=1";
        this.server.enqueue(new MockResponse());
        this.get(this.client, path);
        zipkin2.Span span = this.takeSpan();
        Assertions.assertThat((Map)span.tags()).containsEntry((Object)"http.path", (Object)"/foo");
    }

    @Test
    public void finishedSpanHandlerSeesException() throws Exception {
        this.finishedSpanHandlerSeesException(this.get());
    }

    @Test
    public void reportsSpanOnTransportException() throws Exception {
        this.checkReportsSpanOnTransportException(this.get());
    }

    @Test
    public void errorTag_onTransportException() throws Exception {
        zipkin2.Span span = this.checkReportsSpanOnTransportException(this.get());
        Assertions.assertThat((Map)span.tags()).containsKey((Object)"error");
    }

    Callable<Void> get() {
        return () -> {
            this.get(this.client, "/foo");
            return null;
        };
    }

    void finishedSpanHandlerSeesException(Callable<Void> get) throws Exception {
        final AtomicReference caughtThrowable = new AtomicReference();
        this.close();
        this.httpTracing = HttpTracing.create((Tracing)this.tracingBuilder(Sampler.ALWAYS_SAMPLE).addFinishedSpanHandler(new FinishedSpanHandler(){

            public boolean handle(TraceContext context, MutableSpan span) {
                caughtThrowable.set(span.error());
                return true;
            }
        }).build());
        this.client = this.newClient(this.server.getPort());
        this.checkReportsSpanOnTransportException(get);
        Assertions.assertThat((Throwable)((Throwable)caughtThrowable.get())).isNotNull();
    }

    zipkin2.Span checkReportsSpanOnTransportException(Callable<Void> get) throws InterruptedException {
        this.server.enqueue(new MockResponse().setSocketPolicy(SocketPolicy.DISCONNECT_AT_START));
        try {
            get.call();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.takeSpan();
    }

    protected String url(String pathIncludingQuery) {
        return "http://127.0.0.1:" + this.server.getPort() + pathIncludingQuery;
    }

    protected RecordedRequest takeRequest() throws InterruptedException {
        return this.server.takeRequest(3L, TimeUnit.SECONDS);
    }
}

