/*
 * Decompiled with CFR 0.152.
 */
package brave.test.http;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracing;
import brave.handler.FinishedSpanHandler;
import brave.handler.MutableSpan;
import brave.http.HttpAdapter;
import brave.http.HttpRequestMatchers;
import brave.http.HttpRequestParser;
import brave.http.HttpResponseParser;
import brave.http.HttpRuleSampler;
import brave.http.HttpServerParser;
import brave.http.HttpTracing;
import brave.propagation.TraceContext;
import brave.sampler.Sampler;
import brave.sampler.SamplerFunction;
import brave.test.http.ITHttp;
import brave.test.http.Log4J2Log;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.Buffer;
import okio.BufferedSource;
import okio.Sink;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.junit.AssumptionViolatedException;
import org.junit.Before;
import org.junit.Test;
import zipkin2.Endpoint;
import zipkin2.Span;

public abstract class ITHttpServer
extends ITHttp {
    OkHttpClient client = new OkHttpClient();
    final HttpRequestParser addHttpUrlTag = (request, context, span) -> {
        HttpRequestParser.DEFAULT.parse(request, context, span);
        span.tag("http.url", request.url());
    };

    @Before
    public void setup() throws Exception {
        Log.setLog((Logger)new Log4J2Log());
        this.httpTracing = HttpTracing.create((Tracing)this.tracingBuilder(Sampler.ALWAYS_SAMPLE).build());
        this.init();
    }

    protected abstract void init() throws Exception;

    protected abstract String url(String var1);

    @Test
    public void usesExistingTraceId() throws Exception {
        String path = "/foo";
        String traceId = "463ac35c9f6413ad";
        String parentId = "463ac35c9f6413ad";
        String spanId = "48485a3953bb6124";
        this.get(new Request.Builder().url(this.url(path)).header("X-B3-TraceId", "463ac35c9f6413ad").header("X-B3-ParentSpanId", "463ac35c9f6413ad").header("X-B3-SpanId", "48485a3953bb6124").header("X-B3-Sampled", "1").build());
        zipkin2.Span span = this.takeSpan();
        Assertions.assertThat((String)span.traceId()).isEqualTo("463ac35c9f6413ad");
        Assertions.assertThat((String)span.parentId()).isEqualTo("463ac35c9f6413ad");
        Assertions.assertThat((String)span.id()).isEqualTo("48485a3953bb6124");
    }

    @Test
    public void readsExtra_newTrace() throws Exception {
        this.readsExtra(new Request.Builder());
        this.takeSpan();
    }

    @Test
    public void readsExtra_unsampled() throws Exception {
        this.readsExtra(new Request.Builder().header("X-B3-Sampled", "0"));
    }

    @Test
    public void readsExtra_existingTrace() throws Exception {
        String traceId = "463ac35c9f6413ad";
        this.readsExtra(new Request.Builder().header("X-B3-TraceId", traceId).header("X-B3-SpanId", traceId));
        zipkin2.Span span = this.takeSpan();
        Assertions.assertThat((String)span.traceId()).isEqualTo(traceId);
        Assertions.assertThat((String)span.id()).isEqualTo(traceId);
    }

    void readsExtra(Request.Builder builder) throws Exception {
        Request request = builder.url(this.url("/extra")).header("user-id", "joey").build();
        Response response = this.get(request);
        Assertions.assertThat((boolean)response.isSuccessful()).isTrue();
        Assertions.assertThat((String)response.body().source().readUtf8()).isEqualTo("joey");
    }

    @Test
    public void samplingDisabled() throws Exception {
        this.httpTracing = HttpTracing.create((Tracing)this.tracingBuilder(Sampler.NEVER_SAMPLE).build());
        this.init();
        this.get("/foo");
    }

    @Test
    public void customSampler() throws Exception {
        String path = "/foo";
        HttpRuleSampler sampler = HttpRuleSampler.newBuilder().putRule(HttpRequestMatchers.pathStartsWith((String)path), Sampler.NEVER_SAMPLE).build();
        this.httpTracing = this.httpTracing.toBuilder().serverSampler((SamplerFunction)sampler).build();
        this.init();
        Request request = new Request.Builder().url(this.url(path)).build();
        try (Response response = this.client.newCall(request).execute();){
            Assertions.assertThat((boolean)response.isSuccessful()).isTrue();
        }
    }

    @Test
    public void async() throws Exception {
        Response response = this.get("/async");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)response.isSuccessful()).withFailMessage("not successful: " + response, new Object[0])).isTrue();
        this.takeSpan();
    }

    @Test
    public void createsChildSpan() throws Exception {
        this.get("/child");
        zipkin2.Span child = this.takeSpan();
        zipkin2.Span parent = this.takeSpan();
        Assertions.assertThat((String)parent.traceId()).isEqualTo(child.traceId());
        Assertions.assertThat((String)parent.id()).isEqualTo(child.parentId());
        Assertions.assertThat((Long)parent.timestamp()).isLessThan((Comparable)child.timestamp());
        Assertions.assertThat((Long)parent.duration()).isGreaterThan((Comparable)child.duration());
    }

    @Test
    public void reportsClientAddress() throws Exception {
        this.get("/foo");
        zipkin2.Span span = this.takeSpan();
        Assertions.assertThat((Object)span.remoteEndpoint()).isNotNull();
    }

    @Test
    public void reportsClientAddress_XForwardedFor() throws Exception {
        this.get(new Request.Builder().url(this.url("/foo")).header("X-Forwarded-For", "1.2.3.4").build());
        zipkin2.Span span = this.takeSpan();
        Assertions.assertThat((Object)span.remoteEndpoint()).extracting(Endpoint::ipv4).isEqualTo((Object)"1.2.3.4");
    }

    @Test
    public void reportsServerKindToZipkin() throws Exception {
        this.get("/foo");
        zipkin2.Span span = this.takeSpan();
        Assertions.assertThat((Comparable)span.kind()).isEqualTo((Object)Span.Kind.SERVER);
    }

    @Test
    public void defaultSpanNameIsMethodNameOrRoute() throws Exception {
        this.get("/foo");
        zipkin2.Span span = this.takeSpan();
        if (!span.name().equals("get")) {
            Assertions.assertThat((String)span.name()).isEqualTo("get /foo");
        }
    }

    @Test
    public void readsRequestAtResponseTime() throws Exception {
        this.httpTracing = this.httpTracing.toBuilder().serverResponseParser((response, context, span) -> span.tag("http.url", response.request().url())).build();
        this.init();
        String uri = "/foo?z=2&yAA=1";
        this.get(uri);
        Assertions.assertThat((Map)this.takeSpan().tags()).containsEntry((Object)"http.url", (Object)this.url(uri));
    }

    @Test
    public void supportsPortableCustomization() throws Exception {
        this.httpTracing = this.httpTracing.toBuilder().serverRequestParser((request, context, span) -> {
            span.name(request.method().toLowerCase() + " " + request.path());
            span.tag("http.url", request.url());
            span.tag("request_customizer.is_span", (span instanceof Span) + "");
        }).serverResponseParser((response, context, span) -> {
            HttpResponseParser.DEFAULT.parse(response, context, span);
            span.tag("response_customizer.is_span", (span instanceof Span) + "");
        }).build();
        this.init();
        String uri = "/foo?z=2&yAA=1";
        this.get(uri);
        zipkin2.Span span2 = this.takeSpan();
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)span2.tags()).containsEntry((Object)"http.url", (Object)this.url(uri))).containsEntry((Object)"request_customizer.is_span", (Object)"false")).containsEntry((Object)"response_customizer.is_span", (Object)"false");
    }

    @Test
    @Deprecated
    public void supportsPortableCustomizationDeprecated() throws Exception {
        this.httpTracing = this.httpTracing.toBuilder().serverParser(new HttpServerParser(){

            public <Req> void request(HttpAdapter<Req, ?> adapter, Req req, SpanCustomizer customizer) {
                customizer.tag("http.url", adapter.url(req));
                customizer.tag("context.visible", String.valueOf(ITHttpServer.this.currentTraceContext.get() != null));
                customizer.tag("request_customizer.is_span", (customizer instanceof Span) + "");
            }

            public <Resp> void response(HttpAdapter<?, Resp> adapter, Resp res, Throwable error, SpanCustomizer customizer) {
                super.response(adapter, res, error, customizer);
                customizer.tag("response_customizer.is_span", (customizer instanceof Span) + "");
            }
        }).build();
        this.init();
        String uri = "/foo?z=2&yAA=1";
        this.get(uri);
        zipkin2.Span span = this.takeSpan();
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)span.tags()).containsEntry((Object)"http.url", (Object)this.url(uri))).containsEntry((Object)"context.visible", (Object)"true")).containsEntry((Object)"request_customizer.is_span", (Object)"false")).containsEntry((Object)"response_customizer.is_span", (Object)"false");
    }

    @Test
    public void httpRoute() throws Exception {
        this.httpTracing = this.httpTracing.toBuilder().serverRequestParser(this.addHttpUrlTag).build();
        this.init();
        this.routeBasedRequestNameIncludesPathPrefix("/items");
    }

    @Test
    public void httpRoute_nested() throws Exception {
        this.httpTracing = this.httpTracing.toBuilder().serverRequestParser(this.addHttpUrlTag).build();
        this.init();
        this.routeBasedRequestNameIncludesPathPrefix("/nested/items");
    }

    @Test
    public void httpRoute_async() throws Exception {
        this.httpTracing = this.httpTracing.toBuilder().serverRequestParser(this.addHttpUrlTag).build();
        this.init();
        this.routeBasedRequestNameIncludesPathPrefix("/async_items");
    }

    private void routeBasedRequestNameIncludesPathPrefix(String prefix) throws Exception {
        Response request1 = this.get(prefix + "/1?foo");
        Response request2 = this.get(prefix + "/2?bar");
        Assertions.assertThat((boolean)request1.isSuccessful()).isTrue();
        Assertions.assertThat((boolean)request2.isSuccessful()).isTrue();
        Assertions.assertThat((String)request1.body().string()).isEqualTo("1");
        Assertions.assertThat((String)request2.body().string()).isEqualTo("2");
        zipkin2.Span span1 = this.takeSpan();
        zipkin2.Span span2 = this.takeSpan();
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)span1.tags()).containsEntry((Object)"http.method", (Object)"GET")).containsEntry((Object)"http.path", (Object)(prefix + "/1"))).containsEntry((Object)"http.url", (Object)this.url(prefix + "/1?foo"));
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)span2.tags()).containsEntry((Object)"http.method", (Object)"GET")).containsEntry((Object)"http.path", (Object)(prefix + "/2"))).containsEntry((Object)"http.url", (Object)this.url(prefix + "/2?bar"));
        LinkedHashSet<String> routeBasedNames = new LinkedHashSet<String>(Arrays.asList(span1.name(), span2.name()));
        Assertions.assertThat(routeBasedNames).hasSize(1);
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)((String)routeBasedNames.iterator().next())).startsWith((CharSequence)("get " + prefix))).doesNotEndWith((CharSequence)"/")).doesNotContain(new CharSequence[]{"//"});
    }

    @Test
    public void notFound() throws Exception {
        Assertions.assertThat((int)this.call("GET", "/foo/bark").code()).isEqualTo(404);
        zipkin2.Span span = this.takeSpan();
        ((MapAssert)((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)span.tags()).hasSize(4)).containsEntry((Object)"http.method", (Object)"GET")).containsEntry((Object)"http.path", (Object)"/foo/bark")).containsEntry((Object)"http.status_code", (Object)"404")).containsKey((Object)"error");
        String name = span.name();
        if (name != null && !"get".equals(name)) {
            Assertions.assertThat((String)name).isEqualTo("get not_found");
        }
    }

    @Test
    public void options() throws Exception {
        Assertions.assertThat((boolean)this.call("OPTIONS", "/").isSuccessful()).isTrue();
        zipkin2.Span span = this.takeSpan();
        ((MapAssert)Assertions.assertThat((Map)span.tags()).containsEntry((Object)"http.method", (Object)"OPTIONS")).containsEntry((Object)"http.path", (Object)"/");
        String name = span.name();
        if (name != null && !"options".equals(name)) {
            Assertions.assertThat((String)name).isEqualTo("options /");
        }
    }

    @Test
    public void addsStatusCode_badRequest() throws Exception {
        try {
            this.get("/badrequest");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        zipkin2.Span span = this.takeSpan();
        ((MapAssert)Assertions.assertThat((Map)span.tags()).containsEntry((Object)"http.status_code", (Object)"400")).containsEntry((Object)"error", (Object)"400");
    }

    @Test
    public void httpPathTagExcludesQueryParams() throws Exception {
        this.get("/foo?z=2&yAA=1");
        zipkin2.Span span = this.takeSpan();
        Assertions.assertThat((Map)span.tags()).containsEntry((Object)"http.path", (Object)"/foo");
    }

    @Test
    public void httpStatusCodeTagMatchesResponse_onException() throws Exception {
        this.httpStatusCodeTagMatchesResponse_onException("/exception");
    }

    @Test
    public void httpStatusCodeTagMatchesResponse_onException_async() throws Exception {
        this.httpStatusCodeTagMatchesResponse_onException("/exceptionAsync");
    }

    zipkin2.Span httpStatusCodeTagMatchesResponse_onException(String path) throws Exception {
        Response response = this.get(path);
        zipkin2.Span span = this.takeSpan();
        Assertions.assertThat((Map)span.tags()).containsEntry((Object)"http.status_code", (Object)String.valueOf(response.code()));
        return span;
    }

    @Test
    public void errorTag_exceptionOverridesHttpStatus() throws Exception {
        this.errorTag_exceptionOverridesHttpStatus("/exception");
    }

    @Test
    public void errorTag_exceptionOverridesHttpStatus_async() throws Exception {
        this.errorTag_exceptionOverridesHttpStatus("/exceptionAsync");
    }

    void errorTag_exceptionOverridesHttpStatus(String path) throws Exception {
        this.get(path);
        zipkin2.Span span = this.takeSpan();
        Assertions.assertThat((String)((String)span.tags().get("error"))).contains(new CharSequence[]{"not ready"});
    }

    @Test
    public void finishedSpanHandlerSeesException() throws Exception {
        this.finishedSpanHandlerSeesException("/exception");
    }

    @Test
    public void finishedSpanHandlerSeesException_async() throws Exception {
        this.finishedSpanHandlerSeesException("/exceptionAsync");
    }

    void finishedSpanHandlerSeesException(String path) throws Exception {
        final AtomicReference caughtThrowable = new AtomicReference();
        this.httpTracing = HttpTracing.create((Tracing)this.tracingBuilder(Sampler.ALWAYS_SAMPLE).addFinishedSpanHandler(new FinishedSpanHandler(){

            public boolean handle(TraceContext context, MutableSpan span) {
                caughtThrowable.set(span.error());
                return true;
            }
        }).build());
        this.init();
        this.get(path);
        this.takeSpan();
        Assertions.assertThat((Throwable)((Throwable)caughtThrowable.get())).isNotNull();
    }

    protected Response get(String path) throws Exception {
        return this.get(new Request.Builder().url(this.url(path)).build());
    }

    protected Response get(Request request) throws Exception {
        Response response = this.call(request);
        if (response.code() == 404) {
            zipkin2.Span span = (zipkin2.Span)this.spans.poll(100L, TimeUnit.MILLISECONDS);
            if (span == null) {
                // empty if block
            }
            throw new AssumptionViolatedException(response.request().url().encodedPath() + " not supported");
        }
        return response;
    }

    Response call(String method, String path) throws IOException {
        return this.call(new Request.Builder().method(method, null).url(this.url(path)).build());
    }

    Response call(Request request) throws IOException {
        request = request.newBuilder().header("test", this.testName.getMethodName()).build();
        try (Response response = this.client.newCall(request).execute();){
            ResponseBody toReturn;
            if (!HttpHeaders.promisesBody((Response)response)) {
                Response response2 = response;
                return response2;
            }
            try (ResponseBody body = response.body();){
                Buffer buffer = new Buffer();
                body.source().readAll((Sink)buffer);
                toReturn = ResponseBody.create((BufferedSource)buffer, (MediaType)body.contentType(), (long)body.contentLength());
            }
            Response response3 = response.newBuilder().body(toReturn).build();
            return response3;
        }
    }
}

