/*
 * Decompiled with CFR 0.152.
 */
package brave.test.http;

import brave.SpanCustomizer;
import brave.Tracer;
import brave.http.HttpTracing;
import brave.propagation.ExtraFieldPropagation;
import brave.propagation.TraceContext;
import brave.test.http.ITServletContainer;
import brave.test.http.ServletContainer;
import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import okhttp3.Request;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.Test;
import zipkin2.Span;

public abstract class ITServlet25Container
extends ITServletContainer {
    Filter delegate;
    Filter userFilter = new Filter(){

        public void init(FilterConfig filterConfig) {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            String extra = ExtraFieldPropagation.get((String)"user-id");
            ((HttpServletResponse)response).setHeader("user-id", extra);
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    };
    Filter traceContextFilter = new Filter(){

        public void init(FilterConfig filterConfig) {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            TraceContext context = (TraceContext)request.getAttribute("brave.propagation.TraceContext");
            String extra = ExtraFieldPropagation.get((TraceContext)context, (String)"user-id");
            ((HttpServletResponse)response).setHeader("user-id", extra);
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    };
    Filter customHttpRoute = new Filter(){

        public void init(FilterConfig filterConfig) {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            request.setAttribute("http.route", (Object)((HttpServletRequest)request).getRequestURI());
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    };
    Filter customHook = new Filter(){

        public void init(FilterConfig filterConfig) {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            ((SpanCustomizer)request.getAttribute("brave.SpanCustomizer")).tag("foo", "bar");
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    };

    protected ITServlet25Container(ServletContainer.ServerController serverController) {
        super(serverController);
    }

    @Test
    public void currentSpanVisibleToOtherFilters() throws Exception {
        this.delegate = this.userFilter;
        String path = "/foo";
        Request request = new Request.Builder().url(this.url(path)).header("user-id", "abcdefg").build();
        try (Response response = this.client.newCall(request).execute();){
            Assertions.assertThat((boolean)response.isSuccessful()).isTrue();
            Assertions.assertThat((String)response.header("user-id")).isEqualTo("abcdefg");
        }
        this.takeSpan();
    }

    @Test
    public void traceContextVisibleToOtherFilters() throws Exception {
        this.delegate = this.traceContextFilter;
        String path = "/foo";
        Request request = new Request.Builder().url(this.url(path)).header("user-id", "abcdefg").build();
        try (Response response = this.client.newCall(request).execute();){
            Assertions.assertThat((boolean)response.isSuccessful()).isTrue();
            Assertions.assertThat((String)response.header("user-id")).isEqualTo("abcdefg");
        }
        this.takeSpan();
    }

    @Test
    public void canSetCustomRoute() throws Exception {
        this.delegate = this.customHttpRoute;
        this.get("/foo");
        Span span = this.takeSpan();
        Assertions.assertThat((String)span.name()).isEqualTo("get /foo");
    }

    @Test
    public void canUseSpanAttribute() throws Exception {
        this.delegate = this.customHook;
        this.get("/foo");
        Span span = this.takeSpan();
        Assertions.assertThat((Map)span.tags()).containsEntry((Object)"foo", (Object)"bar");
    }

    @Override
    public void init(ServletContextHandler handler) {
        handler.addServlet(new ServletHolder((Servlet)new StatusServlet(404)), "/*");
        handler.addServlet(new ServletHolder((Servlet)new StatusServlet(200)), "/foo");
        handler.addServlet(new ServletHolder((Servlet)new ExtraServlet()), "/extra");
        handler.addServlet(new ServletHolder((Servlet)new StatusServlet(400)), "/badrequest");
        handler.addServlet(new ServletHolder((Servlet)new ChildServlet(this.httpTracing)), "/child");
        handler.addServlet(new ServletHolder((Servlet)new ExceptionServlet()), "/exception");
        this.addFilter(handler, this.newTracingFilter());
        this.addFilter(handler, new DelegatingFilter());
    }

    protected abstract Filter newTracingFilter();

    protected abstract void addFilter(ServletContextHandler var1, Filter var2);

    static class StatusServlet
    extends HttpServlet {
        final int status;

        StatusServlet(int status) {
            this.status = status;
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
            resp.setStatus(this.status);
        }
    }

    static class ExtraServlet
    extends HttpServlet {
        ExtraServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            resp.getWriter().print(ExtraFieldPropagation.get((String)"user-id"));
        }
    }

    static class ChildServlet
    extends HttpServlet {
        final Tracer tracer;

        ChildServlet(HttpTracing httpTracing) {
            this.tracer = httpTracing.tracing().tracer();
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
            this.tracer.nextSpan().name("child").start().finish();
            resp.setStatus(200);
        }
    }

    static class ExceptionServlet
    extends HttpServlet {
        ExceptionServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws UnavailableException {
            req.setAttribute("javax.servlet.error.status_code", (Object)503);
            throw new UnavailableException("not ready", 1);
        }
    }

    class DelegatingFilter
    implements Filter {
        DelegatingFilter() {
        }

        public void init(FilterConfig filterConfig) {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            if (ITServlet25Container.this.delegate == null) {
                chain.doFilter(request, response);
            } else {
                ITServlet25Container.this.delegate.doFilter(request, response, chain);
            }
        }

        public void destroy() {
        }
    }
}

