/*
 * Decompiled with CFR 0.152.
 */
package brave.test.http;

import brave.Span;
import brave.Tracing;
import brave.test.http.ITHttpServer;
import brave.test.http.ITServlet25Container;
import brave.test.http.Jetty9ServerController;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;

public abstract class ITServlet3Container
extends ITServlet25Container {
    static ExecutorService executor = Executors.newCachedThreadPool();

    public ITServlet3Container() {
        super(new Jetty9ServerController());
    }

    @AfterAll
    public static void shutdownExecutor() {
        executor.shutdownNow();
    }

    @Test
    protected void forward() throws Exception {
        this.get("/forward");
        this.testSpanHandler.takeRemoteSpan(Span.Kind.SERVER);
    }

    @Test
    protected void forwardAsync() throws Exception {
        this.get("/forwardAsync");
        this.testSpanHandler.takeRemoteSpan(Span.Kind.SERVER);
    }

    @Test
    protected void errorTag_onException_asyncTimeout() throws Exception {
        Response response = this.httpStatusCodeTagMatchesResponse_onUncaughtException("/exceptionAsyncTimeout", "Timed out after 1ms");
        Assertions.assertThat((int)response.code()).isIn(new Object[]{500, 504});
    }

    @Test
    protected void errorTag_onException_asyncDispatch() throws Exception {
        this.httpStatusCodeTagMatchesResponse_onUncaughtException("/exceptionAsyncDispatch", "not ready");
    }

    @Override
    public void init(ServletContextHandler handler) {
        super.init(handler);
        handler.addServlet(new ServletHolder((Servlet)new AsyncServlet()), "/async");
        handler.addServlet(new ServletHolder((Servlet)new ForwardServlet()), "/forward");
        handler.addServlet(new ServletHolder((Servlet)new AsyncForwardServlet()), "/forwardAsync");
        handler.addServlet(new ServletHolder((Servlet)new ExceptionAsyncServlet()), "/exceptionAsync");
        handler.addServlet(new ServletHolder((Servlet)new TimeoutExceptionAsyncServlet()), "/exceptionAsyncTimeout");
        handler.addServlet(new ServletHolder((Servlet)new DispatchExceptionAsyncServlet()), "/exceptionAsyncDispatch");
    }

    static class DispatchExceptionAsyncServlet
    extends HttpServlet {
        DispatchExceptionAsyncServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
            if (DispatcherType.ERROR.equals((Object)req.getDispatcherType())) {
                return;
            }
            if (req.getAttribute("dispatched") != null) {
                throw ITHttpServer.NOT_READY_ISE;
            }
            req.setAttribute("dispatched", (Object)Boolean.TRUE);
            req.startAsync().dispatch();
        }
    }

    static class TimeoutExceptionAsyncServlet
    extends HttpServlet {
        TimeoutExceptionAsyncServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
            if (DispatcherType.ERROR.equals((Object)req.getDispatcherType())) {
                return;
            }
            AsyncContext ctx = req.startAsync();
            ctx.setTimeout(1L);
            ctx.start(() -> {
                resp.setStatus(504);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    ctx.complete();
                }
            });
        }
    }

    static class ExceptionAsyncServlet
    extends HttpServlet {
        ExceptionAsyncServlet() {
        }

        protected void doGet(final HttpServletRequest req, HttpServletResponse resp) {
            if (DispatcherType.ERROR.equals((Object)req.getDispatcherType())) {
                return;
            }
            AsyncContext async = req.startAsync();
            async.addListener(new AsyncListener(){

                public void onComplete(AsyncEvent event) {
                }

                public void onTimeout(AsyncEvent event) {
                }

                public void onError(AsyncEvent event) {
                    req.setAttribute("javax.servlet.error.status_code", (Object)503);
                }

                public void onStartAsync(AsyncEvent event) {
                }
            });
            throw ITHttpServer.NOT_READY_ISE;
        }
    }

    static class AsyncServlet
    extends HttpServlet {
        AsyncServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
            if (Tracing.currentTracer().currentSpan() == null) {
                throw new IllegalStateException("couldn't read current span!");
            }
            AsyncContext ctx = req.startAsync();
            ctx.start(() -> ((AsyncContext)ctx).complete());
        }
    }

    static class AsyncForwardServlet
    extends HttpServlet {
        AsyncForwardServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
            AsyncContext asyncContext = req.startAsync((ServletRequest)req, (ServletResponse)resp);
            executor.execute(() -> asyncContext.dispatch("/async"));
        }
    }

    static class ForwardServlet
    extends HttpServlet {
        ForwardServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            req.getServletContext().getRequestDispatcher("/foo").forward((ServletRequest)req, (ServletResponse)resp);
        }
    }
}

