/*
 * Decompiled with CFR 0.152.
 */
package brave.httpclient;

import brave.Span;
import brave.Tracer;
import brave.http.HttpAdapter;
import brave.http.HttpClientAdapter;
import brave.http.HttpClientHandler;
import brave.http.HttpClientParser;
import brave.http.HttpTracing;
import brave.internal.Nullable;
import brave.propagation.CurrentTraceContext;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.execchain.ClientExecChain;
import org.apache.http.protocol.HttpContext;

class TracingMainExec
implements ClientExecChain {
    static final Propagation.Setter<HttpRequestWrapper, String> SETTER = new Propagation.Setter<HttpRequestWrapper, String>(){

        public void put(HttpRequestWrapper carrier, String key, String value) {
            carrier.setHeader(key, value);
        }

        public String toString() {
            return "HttpRequestWrapper::setHeader";
        }
    };
    static final brave.httpclient.HttpAdapter ADAPTER = new brave.httpclient.HttpAdapter();
    final Tracer tracer;
    final CurrentTraceContext currentTraceContext;
    final HttpClientHandler<HttpRequestWrapper, HttpResponse> handler;
    final HttpClientParser parser;
    @Nullable
    final String serverName;
    final TraceContext.Injector<HttpRequestWrapper> injector;
    final ClientExecChain mainExec;

    TracingMainExec(HttpTracing httpTracing, ClientExecChain mainExec) {
        this.tracer = httpTracing.tracing().tracer();
        this.currentTraceContext = httpTracing.tracing().currentTraceContext();
        this.serverName = "".equals(httpTracing.serverName()) ? null : httpTracing.serverName();
        this.parser = httpTracing.clientParser();
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing, (HttpClientAdapter)ADAPTER);
        this.injector = httpTracing.tracing().propagation().injector(SETTER);
        this.mainExec = mainExec;
    }

    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        Span span = this.tracer.currentSpan();
        if (span != null) {
            this.injector.inject(span.context(), (Object)request);
            this.parseExceptRemote(request, span);
            span.start();
        }
        CloseableHttpResponse response = this.mainExec.execute(route, request, context, execAware);
        if (span != null && this.isRemote((HttpContext)context, span)) {
            this.parseRemote(request, span);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parseExceptRemote(HttpRequestWrapper request, Span span) {
        if (!span.isNoop()) {
            CurrentTraceContext.Scope ws = this.currentTraceContext.maybeScope(span.context());
            try {
                this.parser.request((HttpAdapter)ADAPTER, (Object)request, span.customizer());
            }
            finally {
                ws.close();
            }
        }
    }

    void parseRemote(HttpRequestWrapper request, Span span) {
        brave.httpclient.HttpAdapter.parseTargetAddress(request, span);
        span.kind(Span.Kind.CLIENT);
        if (this.serverName != null) {
            span.remoteServiceName(this.serverName);
        }
    }

    boolean isRemote(HttpContext context, Span span) {
        return true;
    }
}

