/*
 * Decompiled with CFR 0.152.
 */
package brave.jaxrs2;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.http.HttpClientHandler;
import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import brave.http.HttpTracing;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.ext.Provider;

@Provider
@ConstrainedTo(value=RuntimeType.CLIENT)
@Priority(value=0)
public final class TracingClientFilter
implements ClientRequestFilter,
ClientResponseFilter {
    final Tracer tracer;
    final HttpClientHandler<HttpClientRequest, HttpClientResponse> handler;

    public static TracingClientFilter create(Tracing tracing) {
        return new TracingClientFilter(HttpTracing.create((Tracing)tracing));
    }

    public static TracingClientFilter create(HttpTracing httpTracing) {
        return new TracingClientFilter(httpTracing);
    }

    @Inject
    TracingClientFilter(HttpTracing httpTracing) {
        if (httpTracing == null) {
            throw new NullPointerException("HttpTracing == null");
        }
        this.tracer = httpTracing.tracing().tracer();
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing);
    }

    public void filter(ClientRequestContext request) {
        Span span = this.handler.handleSend((HttpClientRequest)new ClientRequestContextWrapper(request));
        request.setProperty(Tracer.SpanInScope.class.getName(), (Object)this.tracer.withSpanInScope(span));
    }

    public void filter(ClientRequestContext request, ClientResponseContext response) {
        Span span = this.tracer.currentSpan();
        if (span == null) {
            return;
        }
        ((Tracer.SpanInScope)request.getProperty(Tracer.SpanInScope.class.getName())).close();
        this.handler.handleReceive((Object)new ClientResponseContextWrapper(request, response), null, span);
    }

    static final class ClientRequestContextWrapper
    extends HttpClientRequest {
        final ClientRequestContext delegate;

        ClientRequestContextWrapper(ClientRequestContext delegate) {
            this.delegate = delegate;
        }

        public Object unwrap() {
            return this.delegate;
        }

        public String method() {
            return this.delegate.getMethod();
        }

        public String path() {
            return this.delegate.getUri().getPath();
        }

        public String url() {
            return this.delegate.getUri().toString();
        }

        public String header(String name) {
            return this.delegate.getHeaderString(name);
        }

        public void header(String name, String value) {
            this.delegate.getHeaders().putSingle((Object)name, (Object)value);
        }
    }

    static final class ClientResponseContextWrapper
    extends HttpClientResponse {
        final ClientRequestContextWrapper request;
        final ClientResponseContext response;

        ClientResponseContextWrapper(ClientRequestContext request, ClientResponseContext response) {
            this.request = new ClientRequestContextWrapper(request);
            this.response = response;
        }

        public Object unwrap() {
            return this.response;
        }

        public ClientRequestContextWrapper request() {
            return this.request;
        }

        public Throwable error() {
            return null;
        }

        public int statusCode() {
            int result = this.response.getStatus();
            return result != -1 ? result : 0;
        }
    }
}

