/*
 * Decompiled with CFR 0.152.
 */
package brave.jakarta.jms;

import brave.jakarta.jms.JmsTracing;
import brave.jakarta.jms.TracingServerSessionPool;
import jakarta.jms.ConnectionConsumer;
import jakarta.jms.JMSException;
import jakarta.jms.ServerSessionPool;

final class TracingConnectionConsumer
implements ConnectionConsumer {
    final ConnectionConsumer delegate;
    final JmsTracing jmsTracing;

    static ConnectionConsumer create(ConnectionConsumer delegate, JmsTracing jmsTracing) {
        if (delegate == null) {
            throw new NullPointerException("connectionConsumer == null");
        }
        if (delegate instanceof TracingConnectionConsumer) {
            return delegate;
        }
        return new TracingConnectionConsumer(delegate, jmsTracing);
    }

    TracingConnectionConsumer(ConnectionConsumer delegate, JmsTracing jmsTracing) {
        this.delegate = delegate;
        this.jmsTracing = jmsTracing;
    }

    public ServerSessionPool getServerSessionPool() throws JMSException {
        return TracingServerSessionPool.create(this.delegate.getServerSessionPool(), this.jmsTracing);
    }

    public void close() throws JMSException {
        this.delegate.close();
    }
}

