/*
 * Decompiled with CFR 0.152.
 */
package brave.jakarta.jms;

import brave.jakarta.jms.JmsTracing;
import brave.jakarta.jms.MessageParser;
import brave.jakarta.jms.TracingConsumer;
import brave.jakarta.jms.TracingMessageListener;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.Queue;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSubscriber;

final class TracingMessageConsumer
extends TracingConsumer<MessageConsumer>
implements QueueReceiver,
TopicSubscriber {
    final int types;

    static TracingMessageConsumer create(MessageConsumer delegate, JmsTracing jmsTracing) {
        if (delegate instanceof TracingMessageConsumer) {
            return (TracingMessageConsumer)delegate;
        }
        return new TracingMessageConsumer(delegate, jmsTracing);
    }

    TracingMessageConsumer(MessageConsumer delegate, JmsTracing jmsTracing) {
        super(delegate, jmsTracing);
        int types = 0;
        if (delegate instanceof QueueSender) {
            types |= 2;
        }
        if (delegate instanceof TopicPublisher) {
            types |= 4;
        }
        this.types = types;
    }

    @Override
    Destination destination(Message message) {
        return MessageParser.destination(message);
    }

    public String getMessageSelector() throws JMSException {
        return ((MessageConsumer)this.delegate).getMessageSelector();
    }

    public MessageListener getMessageListener() throws JMSException {
        return ((MessageConsumer)this.delegate).getMessageListener();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        ((MessageConsumer)this.delegate).setMessageListener(TracingMessageListener.create(listener, this.jmsTracing));
    }

    public Message receive() throws JMSException {
        Message message = ((MessageConsumer)this.delegate).receive();
        this.handleReceive(message);
        return message;
    }

    public Message receive(long timeout) throws JMSException {
        Message message = ((MessageConsumer)this.delegate).receive(timeout);
        this.handleReceive(message);
        return message;
    }

    public Message receiveNoWait() throws JMSException {
        Message message = ((MessageConsumer)this.delegate).receiveNoWait();
        this.handleReceive(message);
        return message;
    }

    public void close() throws JMSException {
        ((MessageConsumer)this.delegate).close();
    }

    public Queue getQueue() throws JMSException {
        this.checkQueueReceiver();
        return ((QueueReceiver)this.delegate).getQueue();
    }

    void checkQueueReceiver() {
        if ((this.types & 2) != 2) {
            throw new IllegalStateException(this.delegate + " is not a QueueReceiver");
        }
    }

    public Topic getTopic() throws JMSException {
        this.checkTopicSubscriber();
        return ((TopicSubscriber)this.delegate).getTopic();
    }

    public boolean getNoLocal() throws JMSException {
        this.checkTopicSubscriber();
        return ((TopicSubscriber)this.delegate).getNoLocal();
    }

    void checkTopicSubscriber() {
        if ((this.types & 4) != 4) {
            throw new IllegalStateException(this.delegate + " is not a TopicSubscriber");
        }
    }
}

