/*
 * Decompiled with CFR 0.152.
 */
package brave.jakarta.jms;

import brave.jakarta.jms.JmsTracing;
import brave.jakarta.jms.TracingConnectionFactory;
import brave.jakarta.jms.TracingXAConnection;
import brave.jakarta.jms.TracingXAJMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.XAConnection;
import jakarta.jms.XAConnectionFactory;
import jakarta.jms.XAJMSContext;
import jakarta.jms.XAQueueConnection;
import jakarta.jms.XAQueueConnectionFactory;
import jakarta.jms.XATopicConnection;
import jakarta.jms.XATopicConnectionFactory;

final class TracingXAConnectionFactory
extends TracingConnectionFactory
implements XAQueueConnectionFactory,
XATopicConnectionFactory {
    static XAConnectionFactory create(XAConnectionFactory delegate, JmsTracing jmsTracing) {
        if (delegate == null) {
            throw new NullPointerException("xaConnectionFactory == null");
        }
        if (delegate instanceof TracingXAConnectionFactory) {
            return delegate;
        }
        return new TracingXAConnectionFactory(delegate, jmsTracing);
    }

    TracingXAConnectionFactory(XAConnectionFactory delegate, JmsTracing jmsTracing) {
        super(delegate, jmsTracing);
    }

    public XAConnection createXAConnection() throws JMSException {
        XAConnectionFactory xacf = (XAConnectionFactory)this.delegate;
        return TracingXAConnection.create(xacf.createXAConnection(), this.jmsTracing);
    }

    public XAConnection createXAConnection(String userName, String password) throws JMSException {
        XAConnectionFactory xacf = (XAConnectionFactory)this.delegate;
        return TracingXAConnection.create(xacf.createXAConnection(userName, password), this.jmsTracing);
    }

    public XAJMSContext createXAContext() {
        XAConnectionFactory xacf = (XAConnectionFactory)this.delegate;
        return TracingXAJMSContext.create(xacf.createXAContext(), this.jmsTracing);
    }

    public XAJMSContext createXAContext(String userName, String password) {
        XAConnectionFactory xacf = (XAConnectionFactory)this.delegate;
        return TracingXAJMSContext.create(xacf.createXAContext(userName, password), this.jmsTracing);
    }

    public XAQueueConnection createXAQueueConnection() throws JMSException {
        this.checkQueueConnectionFactory();
        XAQueueConnectionFactory xaqcf = (XAQueueConnectionFactory)this.delegate;
        return TracingXAConnection.create((XAConnection)xaqcf.createXAQueueConnection(), this.jmsTracing);
    }

    public XAQueueConnection createXAQueueConnection(String userName, String password) throws JMSException {
        this.checkQueueConnectionFactory();
        XAQueueConnectionFactory xaqcf = (XAQueueConnectionFactory)this.delegate;
        return TracingXAConnection.create((XAConnection)xaqcf.createXAQueueConnection(userName, password), this.jmsTracing);
    }

    @Override
    void checkQueueConnectionFactory() {
        if ((this.types & 0x10) != 16) {
            throw new IllegalStateException(this.delegate + " is not an XAQueueConnectionFactory");
        }
    }

    public XATopicConnection createXATopicConnection() throws JMSException {
        this.checkTopicConnectionFactory();
        XATopicConnectionFactory xaqcf = (XATopicConnectionFactory)this.delegate;
        return TracingXAConnection.create((XAConnection)xaqcf.createXATopicConnection(), this.jmsTracing);
    }

    public XATopicConnection createXATopicConnection(String userName, String password) throws JMSException {
        this.checkTopicConnectionFactory();
        XATopicConnectionFactory xaqcf = (XATopicConnectionFactory)this.delegate;
        return TracingXAConnection.create((XAConnection)xaqcf.createXATopicConnection(userName, password), this.jmsTracing);
    }

    @Override
    void checkTopicConnectionFactory() {
        if ((this.types & 0x20) != 32) {
            throw new IllegalStateException(this.delegate + " is not an XATopicConnectionFactory");
        }
    }
}

