/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.Span;
import brave.propagation.CurrentTraceContext;
import javax.jms.CompletionListener;
import javax.jms.Message;

final class TracingCompletionListener
implements CompletionListener {
    final Span span;
    final CompletionListener delegate;
    final CurrentTraceContext current;

    static CompletionListener create(CompletionListener delegate, Span span, CurrentTraceContext current) {
        if (span.isNoop()) {
            return delegate;
        }
        return new TracingCompletionListener(delegate, span, current);
    }

    TracingCompletionListener(CompletionListener delegate, Span span, CurrentTraceContext current) {
        this.span = span;
        this.delegate = delegate;
        this.current = current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCompletion(Message message) {
        try {
            CurrentTraceContext.Scope ws = this.current.maybeScope(this.span.context());
            Throwable throwable = null;
            try {
                this.delegate.onCompletion(message);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ws != null) {
                    if (throwable != null) {
                        try {
                            ws.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        ws.close();
                    }
                }
            }
        }
        finally {
            this.span.finish();
        }
    }

    public void onException(Message message, Exception exception) {
        try {
            this.delegate.onException(message, exception);
            this.span.error((Throwable)exception);
        }
        finally {
            this.span.finish();
        }
    }
}

