/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracer;
import brave.Tracing;
import brave.jms.JmsTracing;
import brave.propagation.TraceContextOrSamplingFlags;
import javax.jms.Message;
import javax.jms.MessageListener;

final class TracingMessageListener
implements MessageListener {
    final MessageListener delegate;
    final JmsTracing jmsTracing;
    final Tracing tracing;
    final Tracer tracer;
    final String remoteServiceName;
    final boolean addConsumerSpan;

    static MessageListener create(MessageListener delegate, JmsTracing jmsTracing) {
        if (delegate instanceof TracingMessageListener) {
            return delegate;
        }
        return new TracingMessageListener(delegate, jmsTracing, true);
    }

    TracingMessageListener(MessageListener delegate, JmsTracing jmsTracing, boolean addConsumerSpan) {
        this.delegate = delegate;
        this.jmsTracing = jmsTracing;
        this.tracing = jmsTracing.tracing;
        this.tracer = jmsTracing.tracing.tracer();
        this.remoteServiceName = jmsTracing.remoteServiceName;
        this.addConsumerSpan = addConsumerSpan;
    }

    public void onMessage(Message message) {
        Span listenerSpan = this.startMessageListenerSpan(message);
        try {
            Tracer.SpanInScope ws = this.tracer.withSpanInScope(listenerSpan);
            Throwable throwable = null;
            try {
                this.delegate.onMessage(message);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ws != null) {
                    if (throwable != null) {
                        try {
                            ws.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        ws.close();
                    }
                }
            }
        }
        catch (Throwable t) {
            listenerSpan.error(t);
            throw t;
        }
        finally {
            listenerSpan.finish();
        }
    }

    Span startMessageListenerSpan(Message message) {
        if (!this.addConsumerSpan) {
            return this.jmsTracing.nextSpan(message).name("on-message").start();
        }
        TraceContextOrSamplingFlags extracted = this.jmsTracing.extractAndClearMessage(message);
        Span consumerSpan = this.tracer.nextSpan(extracted).kind(Span.Kind.CONSUMER).name("receive");
        Span listenerSpan = this.tracer.newChild(consumerSpan.context());
        if (!consumerSpan.isNoop()) {
            long timestamp = this.tracing.clock(consumerSpan.context()).currentTimeMicroseconds();
            consumerSpan.start(timestamp);
            if (this.remoteServiceName != null) {
                consumerSpan.remoteServiceName(this.remoteServiceName);
            }
            this.jmsTracing.tagQueueOrTopic(message, (SpanCustomizer)consumerSpan);
            long consumerFinish = timestamp + 1L;
            consumerSpan.finish(consumerFinish);
            listenerSpan.name("on-message").start(consumerFinish);
        }
        return listenerSpan;
    }
}

