/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.Message;

enum PropertyFilter {
    MESSAGE{

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void filterProperties(Object object, Set<String> namesToClear) {
            Message message = (Message)object;
            ArrayList<Object> retainedProperties = 1.messagePropertiesBuffer();
            try {
                1.doFilterProperties(message, namesToClear, retainedProperties);
            }
            catch (JMSException jMSException) {
            }
            finally {
                retainedProperties.clear();
            }
        }
    }
    ,
    JMS_PRODUCER{

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void filterProperties(Object object, Set<String> namesToClear) {
            JMSProducer jmsProducer = (JMSProducer)object;
            ArrayList<Object> retainedProperties = 2.messagePropertiesBuffer();
            try {
                2.doFilterProperties(jmsProducer, namesToClear, retainedProperties);
            }
            finally {
                retainedProperties.clear();
            }
        }
    };

    static final ThreadLocal<ArrayList<Object>> MESSAGE_PROPERTIES_BUFFER;

    abstract void filterProperties(Object var1, Set<String> var2);

    static void doFilterProperties(Message message, Set<String> namesToClear, ArrayList<Object> retainedProperties) throws JMSException {
        Enumeration names = message.getPropertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object value = message.getObjectProperty(name);
            if (namesToClear.contains(name) || value == null) continue;
            retainedProperties.add(name);
            retainedProperties.add(value);
        }
        message.clearProperties();
        int length = retainedProperties.size();
        for (int i = 0; i < length; i += 2) {
            message.setObjectProperty(retainedProperties.get(i).toString(), retainedProperties.get(i + 1));
        }
    }

    static void doFilterProperties(JMSProducer producer, Set<String> namesToClear, ArrayList<Object> retainedProperties) {
        boolean filtered = false;
        for (String name : producer.getPropertyNames()) {
            Object value = producer.getObjectProperty(name);
            if (!namesToClear.contains(name) && value != null) {
                retainedProperties.add(name);
                retainedProperties.add(value);
                continue;
            }
            filtered = true;
        }
        if (!filtered) {
            return;
        }
        producer.clearProperties();
        int length = retainedProperties.size();
        for (int i = 0; i < length; i += 2) {
            producer.setProperty(retainedProperties.get(i).toString(), retainedProperties.get(i + 1));
        }
    }

    static ArrayList<Object> messagePropertiesBuffer() {
        ArrayList<Object> messagePropertiesBuffer = MESSAGE_PROPERTIES_BUFFER.get();
        if (messagePropertiesBuffer == null) {
            messagePropertiesBuffer = new ArrayList();
            MESSAGE_PROPERTIES_BUFFER.set(messagePropertiesBuffer);
        }
        return messagePropertiesBuffer;
    }

    static {
        MESSAGE_PROPERTIES_BUFFER = new ThreadLocal();
    }
}

