/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracer;
import brave.Tracing;
import brave.internal.Nullable;
import brave.jms.JmsTracing;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import javax.jms.Destination;
import javax.jms.Message;

abstract class TracingConsumer<C> {
    final C delegate;
    final JmsTracing jmsTracing;
    final Tracing tracing;
    final Tracer tracer;
    final TraceContext.Extractor<Message> extractor;
    @Nullable
    final String remoteServiceName;

    TracingConsumer(C delegate, JmsTracing jmsTracing) {
        this.delegate = delegate;
        this.jmsTracing = jmsTracing;
        this.tracing = jmsTracing.tracing;
        this.tracer = this.tracing.tracer();
        this.extractor = jmsTracing.extractor;
        this.remoteServiceName = jmsTracing.remoteServiceName;
    }

    void handleReceive(Message message) {
        if (message == null || this.tracing.isNoop()) {
            return;
        }
        TraceContextOrSamplingFlags extracted = this.jmsTracing.extractAndClearMessage(message);
        Span span = this.tracer.nextSpan(extracted);
        if (!span.isNoop()) {
            span.name("receive").kind(Span.Kind.CONSUMER);
            Destination destination = this.destination(message);
            if (destination != null) {
                this.jmsTracing.tagQueueOrTopic(destination, (SpanCustomizer)span);
            }
            if (this.remoteServiceName != null) {
                span.remoteServiceName(this.remoteServiceName);
            }
            long timestamp = this.tracing.clock(span.context()).currentTimeMicroseconds();
            span.start(timestamp).finish(timestamp);
        }
        this.jmsTracing.setNextParent(message, span.context());
    }

    @Nullable
    abstract Destination destination(Message var1);
}

