/*
 * Decompiled with CFR 0.152.
 */
package brave.servlet;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracing;
import brave.http.HttpServerHandler;
import brave.http.HttpServerResponse;
import brave.http.HttpTracing;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import brave.servlet.internal.ServletRuntime;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class TracingFilter
implements Filter {
    final ServletRuntime servlet = ServletRuntime.get();
    final CurrentTraceContext currentTraceContext;
    final HttpServerHandler<brave.http.HttpServerRequest, HttpServerResponse> handler;

    public static Filter create(Tracing tracing) {
        return new TracingFilter(HttpTracing.create((Tracing)tracing));
    }

    public static Filter create(HttpTracing httpTracing) {
        return new TracingFilter(httpTracing);
    }

    TracingFilter(HttpTracing httpTracing) {
        this.currentTraceContext = httpTracing.tracing().currentTraceContext();
        this.handler = HttpServerHandler.create((HttpTracing)httpTracing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = this.servlet.httpServletResponse(response);
        TraceContext context = (TraceContext)request.getAttribute(TraceContext.class.getName());
        if (context != null) {
            CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(context);
            try {
                chain.doFilter(request, response);
            }
            finally {
                scope.close();
            }
            return;
        }
        Span span = this.handler.handleReceive((brave.http.HttpServerRequest)new HttpServerRequest(httpRequest));
        request.setAttribute(SpanCustomizer.class.getName(), (Object)span.customizer());
        request.setAttribute(TraceContext.class.getName(), (Object)span.context());
        Throwable error = null;
        CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(span.context());
        try {
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
        catch (IOException | Error | RuntimeException | ServletException e) {
            error = e;
            throw e;
        }
        finally {
            if (this.servlet.isAsync(httpRequest)) {
                this.servlet.handleAsync(this.handler, httpRequest, httpResponse, span);
            } else {
                this.handler.handleSend((Object)this.servlet.httpServerResponse(httpRequest, httpResponse), error, span);
            }
            scope.close();
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) {
    }

    static final class HttpServerRequest
    extends brave.http.HttpServerRequest {
        final HttpServletRequest delegate;

        HttpServerRequest(HttpServletRequest delegate) {
            this.delegate = delegate;
        }

        public HttpServletRequest unwrap() {
            return this.delegate;
        }

        public boolean parseClientIpAndPort(Span span) {
            return span.remoteIpAndPort(this.delegate.getRemoteAddr(), this.delegate.getRemotePort());
        }

        public String method() {
            return this.delegate.getMethod();
        }

        public String path() {
            return this.delegate.getRequestURI();
        }

        public String url() {
            StringBuffer url = this.delegate.getRequestURL();
            if (this.delegate.getQueryString() != null && !this.delegate.getQueryString().isEmpty()) {
                url.append('?').append(this.delegate.getQueryString());
            }
            return url.toString();
        }

        public String header(String name) {
            return this.delegate.getHeader(name);
        }
    }
}

