/*
 * Decompiled with CFR 0.152.
 */
package brave.test.propagation;

import brave.internal.Nullable;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import brave.test.util.ClassLoaders;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public abstract class CurrentTraceContextTest {
    protected final CurrentTraceContext currentTraceContext;
    protected final TraceContext context = TraceContext.newBuilder().traceIdHigh(-1L).traceId(1L).spanId(1L).sampled(true).build();
    protected final TraceContext notYetSampledContext = TraceContext.newBuilder().traceId(2L).spanId(1L).build();
    protected final TraceContext unsampledContext = TraceContext.newBuilder().traceId(2L).spanId(2L).sampled(false).build();

    protected abstract Class<? extends Supplier<CurrentTraceContext>> currentSupplier();

    protected CurrentTraceContextTest() {
        this.currentTraceContext = ClassLoaders.newInstance(this.currentSupplier(), this.getClass().getClassLoader()).get();
    }

    protected void verifyImplicitContext(@Nullable TraceContext context) {
    }

    @Test
    public void currentSpan_defaultsToNull() {
        Assertions.assertThat((Object)this.currentTraceContext.get()).isNull();
    }

    @Test
    public void newScope_retainsContext() {
        this.retainsContext(this.currentTraceContext.newScope(this.context));
    }

    @Test
    public void maybeScope_retainsContext() {
        this.retainsContext(this.currentTraceContext.maybeScope(this.context));
    }

    void retainsContext(CurrentTraceContext.Scope scope) {
        try {
            Assertions.assertThat((Object)scope).isNotEqualTo((Object)CurrentTraceContext.Scope.NOOP);
            Assertions.assertThat((Object)this.currentTraceContext.get()).isEqualTo((Object)this.context);
            this.verifyImplicitContext(this.context);
        }
        finally {
            scope.close();
        }
    }

    @Test
    public void newScope_noticesDifferentSpanId() {
        this.noticesDifferentSpanId(this.currentTraceContext.newScope(this.context));
    }

    @Test
    public void maybeScope_noticesDifferentSpanId() {
        this.noticesDifferentSpanId(this.currentTraceContext.maybeScope(this.context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noticesDifferentSpanId(CurrentTraceContext.Scope scope) {
        TraceContext differentSpanId = this.context.toBuilder().spanId(this.context.spanId() + 1L).build();
        try (CurrentTraceContext.Scope scope2 = this.currentTraceContext.maybeScope(differentSpanId);){
            Assertions.assertThat((Object)scope2).isNotEqualTo((Object)CurrentTraceContext.Scope.NOOP);
            Assertions.assertThat((Object)this.currentTraceContext.get()).isEqualTo((Object)differentSpanId);
            this.verifyImplicitContext(differentSpanId);
        }
        finally {
            scope.close();
        }
    }

    @Test
    public void newScope_noticesDifferentContext() {
        this.noticesDifferentContext(this.currentTraceContext.newScope(this.context));
    }

    @Test
    public void maybeScope_noticesDifferentContext() {
        this.noticesDifferentContext(this.currentTraceContext.maybeScope(this.context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noticesDifferentContext(CurrentTraceContext.Scope scope) {
        try (CurrentTraceContext.Scope scope2 = this.currentTraceContext.maybeScope(this.unsampledContext);){
            Assertions.assertThat((Object)scope2).isNotEqualTo((Object)CurrentTraceContext.Scope.NOOP);
            Assertions.assertThat((Object)this.currentTraceContext.get()).isEqualTo((Object)this.unsampledContext);
            this.verifyImplicitContext(this.unsampledContext);
            try (CurrentTraceContext.Scope scope3 = this.currentTraceContext.maybeScope(this.notYetSampledContext);){
                Assertions.assertThat((Object)scope3).isNotEqualTo((Object)CurrentTraceContext.Scope.NOOP);
                Assertions.assertThat((Object)this.currentTraceContext.get()).isEqualTo((Object)this.notYetSampledContext);
                this.verifyImplicitContext(this.notYetSampledContext);
            }
        }
        finally {
            scope.close();
        }
    }

    @Test
    public void maybeScope_doesntDuplicateContext() {
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(this.context);
             CurrentTraceContext.Scope scope2 = this.currentTraceContext.maybeScope(this.context);){
            Assertions.assertThat((Object)scope2).isEqualTo((Object)CurrentTraceContext.Scope.NOOP);
        }
    }

    @Test
    public void newScope_canClearScope() {
        this.canClearScope(() -> this.currentTraceContext.newScope(null));
    }

    @Test
    public void maybeScope_canClearScope() {
        this.canClearScope(() -> this.currentTraceContext.maybeScope(null));
    }

    @Test
    public void maybeScope_doesntDuplicateContext_onNull() {
        try (CurrentTraceContext.Scope scope2 = this.currentTraceContext.maybeScope(null);){
            Assertions.assertThat((Object)scope2).isEqualTo((Object)CurrentTraceContext.Scope.NOOP);
        }
    }

    void canClearScope(Supplier<CurrentTraceContext.Scope> noScoper) {
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(this.context);){
            try (CurrentTraceContext.Scope noScope = noScoper.get();){
                Assertions.assertThat((Object)noScope).isNotEqualTo((Object)CurrentTraceContext.Scope.NOOP);
                Assertions.assertThat((Object)this.currentTraceContext.get()).isNull();
                this.verifyImplicitContext(null);
            }
            Assertions.assertThat((Object)this.currentTraceContext.get()).isEqualTo((Object)this.context);
            this.verifyImplicitContext(this.context);
        }
    }

    protected void is_inheritable(CurrentTraceContext inheritableCurrentTraceContext) throws Exception {
        ThreadPoolExecutor service = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        try (CurrentTraceContext.Scope scope = inheritableCurrentTraceContext.newScope(this.context);){
            Assertions.assertThat((Object)service.submit(() -> ((CurrentTraceContext)inheritableCurrentTraceContext).get()).get()).isEqualTo((Object)this.context);
        }
        Assertions.assertThat((Object)service.submit(() -> ((CurrentTraceContext)inheritableCurrentTraceContext).get()).get()).isEqualTo((Object)this.context);
        service.shutdownNow();
    }

    @Test
    public void isnt_inheritable() throws Exception {
        ExecutorService service = Executors.newCachedThreadPool();
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(this.context);){
            Assertions.assertThat((Object)service.submit(() -> {
                this.verifyImplicitContext(null);
                return this.currentTraceContext.get();
            }).get()).isNull();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw (Exception)e.getCause();
        }
        Assertions.assertThat((Object)service.submit(() -> ((CurrentTraceContext)this.currentTraceContext).get()).get()).isNull();
        this.verifyImplicitContext(null);
        service.shutdownNow();
    }

    @Test
    public void attachesSpanInCallable_canClear() throws Exception {
        Callable callable = this.currentTraceContext.wrap(() -> {
            Assertions.assertThat((Object)this.currentTraceContext.get()).isNull();
            this.verifyImplicitContext(null);
            return true;
        });
        try (CurrentTraceContext.Scope scope2 = this.currentTraceContext.newScope(this.unsampledContext);){
            callable.call();
            this.verifyImplicitContext(this.unsampledContext);
        }
    }

    @Test
    public void attachesSpanInCallable() throws Exception {
        Callable callable;
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(this.context);){
            callable = this.currentTraceContext.wrap(() -> {
                Assertions.assertThat((Object)this.currentTraceContext.get()).isEqualTo((Object)this.context);
                this.verifyImplicitContext(this.context);
                return true;
            });
            callable.call();
        }
        try (CurrentTraceContext.Scope scope2 = this.currentTraceContext.newScope(this.unsampledContext);){
            callable.call();
            this.verifyImplicitContext(this.unsampledContext);
        }
    }

    @Test
    public void restoresSpanAfterCallable() throws Exception {
        try (CurrentTraceContext.Scope scope0 = this.currentTraceContext.newScope(this.context);){
            this.attachesSpanInCallable();
            Assertions.assertThat((Object)this.currentTraceContext.get()).isEqualTo((Object)this.context);
            this.verifyImplicitContext(this.context);
        }
    }

    @Test
    public void attachesSpanInRunnable() throws Exception {
        Runnable runnable;
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(this.context);){
            runnable = this.currentTraceContext.wrap(() -> {
                Assertions.assertThat((Object)this.currentTraceContext.get()).isEqualTo((Object)this.context);
                this.verifyImplicitContext(this.context);
            });
            runnable.run();
        }
        try (CurrentTraceContext.Scope scope2 = this.currentTraceContext.newScope(this.unsampledContext);){
            runnable.run();
            this.verifyImplicitContext(this.unsampledContext);
        }
    }

    @Test
    public void restoresSpanAfterRunnable() throws Exception {
        TraceContext context0 = TraceContext.newBuilder().traceId(3L).spanId(3L).build();
        try (CurrentTraceContext.Scope scope0 = this.currentTraceContext.newScope(context0);){
            this.attachesSpanInRunnable();
            Assertions.assertThat((Object)this.currentTraceContext.get()).isEqualTo((Object)context0);
            this.verifyImplicitContext(context0);
        }
    }

    @Test
    public void unloadable_unused() {
        ClassLoaders.assertRunIsUnloadableWithSupplier(Unused.class, this.currentSupplier());
    }

    @Test
    public void unloadable_afterScopeClose() {
        ClassLoaders.assertRunIsUnloadableWithSupplier(ClosedScope.class, this.currentSupplier());
    }

    @Test
    public void notUnloadable_whenScopeLeaked() {
        try {
            ClassLoaders.assertRunIsUnloadableWithSupplier(LeakedScope.class, this.currentSupplier());
            Assertions.failBecauseExceptionWasNotThrown(AssertionError.class);
        }
        catch (AssertionError e) {
            this.currentTraceContext.newScope(null);
        }
    }

    static class Unused
    extends ClassLoaders.ConsumerRunnable<CurrentTraceContext> {
        Unused() {
        }

        @Override
        public void accept(CurrentTraceContext currentTraceContext) {
        }
    }

    static class ClosedScope
    extends ClassLoaders.ConsumerRunnable<CurrentTraceContext> {
        ClosedScope() {
        }

        @Override
        public void accept(CurrentTraceContext current) {
            CurrentTraceContext.Scope ws = current.newScope(TraceContext.newBuilder().traceId(1L).spanId(2L).build());
            if (ws != null) {
                ws.close();
            }
        }
    }

    static class LeakedScope
    extends ClassLoaders.ConsumerRunnable<CurrentTraceContext> {
        LeakedScope() {
        }

        @Override
        public void accept(CurrentTraceContext current) {
            current.newScope(TraceContext.newBuilder().traceId(1L).spanId(2L).build());
        }
    }
}

