/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.postgres;

import com.google.common.collect.ImmutableMap;
import io.zonky.test.db.AutoConfigureEmbeddedDatabase;
import io.zonky.test.db.AutoConfigureEmbeddedDatabases;
import io.zonky.test.db.flyway.DefaultFlywayDataSourceContext;
import io.zonky.test.db.flyway.FlywayClassUtils;
import io.zonky.test.db.flyway.FlywayDataSourceContext;
import io.zonky.test.db.postgres.EmptyEmbeddedPostgresDataSourceFactoryBean;
import io.zonky.test.db.postgres.FlywayEmbeddedPostgresDataSourceFactoryBean;
import io.zonky.test.db.provider.DatabaseDescriptor;
import io.zonky.test.db.provider.DatabaseType;
import io.zonky.test.db.provider.ProviderType;
import io.zonky.test.db.provider.impl.DockerPostgresDatabaseProvider;
import io.zonky.test.db.provider.impl.OpenTablePostgresDatabaseProvider;
import io.zonky.test.db.provider.impl.PrefetchingDatabaseProvider;
import io.zonky.test.db.provider.impl.YandexPostgresDatabaseProvider;
import io.zonky.test.db.provider.impl.ZonkyPostgresDatabaseProvider;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.flywaydb.core.Flyway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.autoconfigure.flyway.FlywayProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class EmbeddedPostgresContextCustomizerFactory
implements ContextCustomizerFactory {
    private static final Logger logger = LoggerFactory.getLogger(EmbeddedPostgresContextCustomizerFactory.class);
    private static final boolean flywayNameAttributePresent = FlywayClassUtils.isFlywayNameAttributePresent();
    private static final boolean repeatableAnnotationPresent = FlywayClassUtils.isRepeatableFlywayTestAnnotationPresent();

    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        Set databaseAnnotations = AnnotatedElementUtils.getMergedRepeatableAnnotations(testClass, AutoConfigureEmbeddedDatabase.class, AutoConfigureEmbeddedDatabases.class);
        if (!(databaseAnnotations = (Set)databaseAnnotations.stream().filter(EmbeddedPostgresContextCustomizerFactory.distinctByKey(AutoConfigureEmbeddedDatabase::beanName)).filter(databaseAnnotation -> databaseAnnotation.type() == AutoConfigureEmbeddedDatabase.EmbeddedDatabaseType.POSTGRES).filter(databaseAnnotation -> databaseAnnotation.replace() != AutoConfigureEmbeddedDatabase.Replace.NONE).collect(Collectors.toCollection(LinkedHashSet::new))).isEmpty()) {
            return new PreloadableEmbeddedPostgresContextCustomizer(databaseAnnotations);
        }
        return null;
    }

    protected static void registerBeanIfMissing(BeanDefinitionRegistry registry, String beanName, Class<?> beanClass) {
        if (!registry.containsBeanDefinition(beanName)) {
            RootBeanDefinition providerDefinition = new RootBeanDefinition(beanClass);
            registry.registerBeanDefinition(beanName, (BeanDefinition)providerDefinition);
        }
    }

    protected static BeanDefinitionRegistry getBeanDefinitionRegistry(ApplicationContext context) {
        if (context instanceof BeanDefinitionRegistry) {
            return (BeanDefinitionRegistry)context;
        }
        if (context instanceof AbstractApplicationContext) {
            return (BeanDefinitionRegistry)((AbstractApplicationContext)context).getBeanFactory();
        }
        throw new IllegalStateException("Could not locate BeanDefinitionRegistry");
    }

    protected static BeanDefinitionHolder getDataSourceBeanDefinition(ConfigurableListableBeanFactory beanFactory, AutoConfigureEmbeddedDatabase annotation) {
        if (StringUtils.isNotBlank((CharSequence)annotation.beanName())) {
            if (beanFactory.containsBean(annotation.beanName())) {
                BeanDefinition beanDefinition = beanFactory.getBeanDefinition(annotation.beanName());
                return new BeanDefinitionHolder(beanDefinition, annotation.beanName());
            }
            return new BeanDefinitionHolder((BeanDefinition)new RootBeanDefinition(), annotation.beanName());
        }
        Object[] beanNames = beanFactory.getBeanNamesForType(DataSource.class);
        if (ObjectUtils.isEmpty((Object[])beanNames)) {
            throw new IllegalStateException("No DataSource beans found, embedded version will not be used, you must specify data source name - use @AutoConfigureEmbeddedDatabase(beanName = \"dataSource\") annotation");
        }
        if (beanNames.length == 1) {
            Object beanName = beanNames[0];
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition((String)beanName);
            return new BeanDefinitionHolder(beanDefinition, (String)beanName);
        }
        for (Object beanName : beanNames) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition((String)beanName);
            if (!beanDefinition.isPrimary()) continue;
            return new BeanDefinitionHolder(beanDefinition, (String)beanName);
        }
        throw new IllegalStateException("No primary DataSource found, embedded version will not be used");
    }

    protected static BeanDefinitionHolder getDataSourceContextBeanDefinition(ConfigurableListableBeanFactory beanFactory, String flywayName) {
        Object[] beanNames = beanFactory.getBeanNamesForType(FlywayDataSourceContext.class, true, false);
        if (ObjectUtils.isEmpty((Object[])beanNames)) {
            return null;
        }
        if (beanNames.length == 1) {
            Object beanName = beanNames[0];
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition((String)beanName);
            return new BeanDefinitionHolder(beanDefinition, (String)beanName);
        }
        if (beanFactory.containsBean(flywayName + "DataSourceContext")) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(flywayName + "DataSourceContext");
            return new BeanDefinitionHolder(beanDefinition, flywayName + "DataSourceContext");
        }
        return null;
    }

    protected static BeanDefinitionHolder getFlywayBeanDefinition(ConfigurableListableBeanFactory beanFactory) {
        String[] beanNames = beanFactory.getBeanNamesForType(Flyway.class, true, false);
        if (beanNames.length == 1) {
            String beanName = beanNames[0];
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
            return new BeanDefinitionHolder(beanDefinition, beanName);
        }
        return null;
    }

    protected static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    protected static class PreloadableEmbeddedPostgresRegistrar
    implements BeanDefinitionRegistryPostProcessor,
    EnvironmentAware {
        private final Set<AutoConfigureEmbeddedDatabase> databaseAnnotations;
        private Environment environment;

        public PreloadableEmbeddedPostgresRegistrar(Set<AutoConfigureEmbeddedDatabase> databaseAnnotations) {
            this.databaseAnnotations = databaseAnnotations;
        }

        public void setEnvironment(Environment environment) {
            this.environment = environment;
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)registry, (String)"Embedded Database Auto-configuration can only be used with a ConfigurableListableBeanFactory");
            ConfigurableListableBeanFactory beanFactory = (ConfigurableListableBeanFactory)registry;
            EmbeddedPostgresContextCustomizerFactory.registerBeanIfMissing(registry, "defaultDatabaseProvider", PrefetchingDatabaseProvider.class);
            if (ClassUtils.isPresent((String)"org.testcontainers.containers.PostgreSQLContainer", null)) {
                EmbeddedPostgresContextCustomizerFactory.registerBeanIfMissing(registry, "dockerPostgresProvider", DockerPostgresDatabaseProvider.class);
            }
            if (ClassUtils.isPresent((String)"io.zonky.test.db.postgres.embedded.EmbeddedPostgres", null)) {
                EmbeddedPostgresContextCustomizerFactory.registerBeanIfMissing(registry, "zonkyPostgresProvider", ZonkyPostgresDatabaseProvider.class);
            }
            if (ClassUtils.isPresent((String)"com.opentable.db.postgres.embedded.EmbeddedPostgres", null)) {
                EmbeddedPostgresContextCustomizerFactory.registerBeanIfMissing(registry, "openTablePostgresProvider", OpenTablePostgresDatabaseProvider.class);
            }
            if (ClassUtils.isPresent((String)"ru.yandex.qatools.embed.postgresql.EmbeddedPostgres", null)) {
                EmbeddedPostgresContextCustomizerFactory.registerBeanIfMissing(registry, "yandexPostgresProvider", YandexPostgresDatabaseProvider.class);
            }
            if (ClassUtils.isPresent((String)"org.springframework.boot.autoconfigure.flyway.FlywayProperties", null)) {
                EmbeddedPostgresContextCustomizerFactory.registerBeanIfMissing(registry, "flywayPropertiesPostProcessor", FlywayPropertiesPostProcessor.class);
            }
            for (AutoConfigureEmbeddedDatabase databaseAnnotation : this.databaseAnnotations) {
                DatabaseDescriptor databaseDescriptor = this.resolveDatabaseDescriptor(this.environment, databaseAnnotation);
                BeanDefinitionHolder dataSourceInfo = EmbeddedPostgresContextCustomizerFactory.getDataSourceBeanDefinition(beanFactory, databaseAnnotation);
                BeanDefinitionHolder flywayInfo = EmbeddedPostgresContextCustomizerFactory.getFlywayBeanDefinition(beanFactory);
                RootBeanDefinition dataSourceDefinition = new RootBeanDefinition();
                dataSourceDefinition.setPrimary(dataSourceInfo.getBeanDefinition().isPrimary());
                if (flywayInfo == null || this.databaseAnnotations.size() > 1) {
                    dataSourceDefinition.setBeanClass(EmptyEmbeddedPostgresDataSourceFactoryBean.class);
                    dataSourceDefinition.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)databaseDescriptor);
                } else {
                    BeanDefinitionHolder contextInfo = EmbeddedPostgresContextCustomizerFactory.getDataSourceContextBeanDefinition(beanFactory, flywayInfo.getBeanName());
                    if (contextInfo == null) {
                        RootBeanDefinition dataSourceContextDefinition = new RootBeanDefinition();
                        dataSourceContextDefinition.setBeanClass(DefaultFlywayDataSourceContext.class);
                        registry.registerBeanDefinition("defaultDataSourceContext", (BeanDefinition)dataSourceContextDefinition);
                        contextInfo = new BeanDefinitionHolder((BeanDefinition)dataSourceContextDefinition, "defaultDataSourceContext");
                    }
                    contextInfo.getBeanDefinition().getPropertyValues().addPropertyValue("descriptor", (Object)databaseDescriptor);
                    dataSourceDefinition.setBeanClass(FlywayEmbeddedPostgresDataSourceFactoryBean.class);
                    dataSourceDefinition.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)flywayInfo.getBeanName());
                    dataSourceDefinition.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)contextInfo.getBeanName());
                }
                String dataSourceBeanName = dataSourceInfo.getBeanName();
                if (registry.containsBeanDefinition(dataSourceBeanName)) {
                    logger.info("Replacing '{}' DataSource bean with embedded version", (Object)dataSourceBeanName);
                    registry.removeBeanDefinition(dataSourceBeanName);
                }
                registry.registerBeanDefinition(dataSourceBeanName, (BeanDefinition)dataSourceDefinition);
            }
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }

        protected DatabaseDescriptor resolveDatabaseDescriptor(Environment environment, AutoConfigureEmbeddedDatabase databaseAnnotation) {
            String providerName = databaseAnnotation.provider() != AutoConfigureEmbeddedDatabase.DatabaseProvider.DEFAULT ? databaseAnnotation.provider().name() : environment.getProperty("zonky.test.database.provider", ProviderType.ZONKY.toString());
            return new DatabaseDescriptor(DatabaseType.POSTGRES, ProviderType.valueOf(providerName));
        }
    }

    protected static class FlywayPropertiesPostProcessor
    implements BeanPostProcessor {
        protected FlywayPropertiesPostProcessor() {
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof FlywayProperties) {
                FlywayProperties properties = (FlywayProperties)bean;
                properties.setUrl(null);
                properties.setUser(null);
                properties.setPassword(null);
            }
            return bean;
        }
    }

    protected static class EnvironmentPostProcessor
    implements BeanDefinitionRegistryPostProcessor {
        private final ConfigurableEnvironment environment;

        public EnvironmentPostProcessor(ConfigurableEnvironment environment) {
            this.environment = environment;
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            this.environment.getPropertySources().addFirst((PropertySource)new MapPropertySource(PreloadableEmbeddedPostgresContextCustomizer.class.getSimpleName(), (Map)ImmutableMap.of((Object)"spring.test.database.replace", (Object)"NONE")));
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }
    }

    protected static class PreloadableEmbeddedPostgresContextCustomizer
    implements ContextCustomizer {
        private final Set<AutoConfigureEmbeddedDatabase> databaseAnnotations;

        public PreloadableEmbeddedPostgresContextCustomizer(Set<AutoConfigureEmbeddedDatabase> databaseAnnotations) {
            this.databaseAnnotations = databaseAnnotations;
        }

        public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
            context.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new EnvironmentPostProcessor(context.getEnvironment()));
            BeanDefinitionRegistry registry = EmbeddedPostgresContextCustomizerFactory.getBeanDefinitionRegistry((ApplicationContext)context);
            RootBeanDefinition registrarDefinition = new RootBeanDefinition();
            registrarDefinition.setBeanClass(PreloadableEmbeddedPostgresRegistrar.class);
            registrarDefinition.getConstructorArgumentValues().addIndexedArgumentValue(0, this.databaseAnnotations);
            registry.registerBeanDefinition("preloadableEmbeddedPostgresRegistrar", (BeanDefinition)registrarDefinition);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PreloadableEmbeddedPostgresContextCustomizer that = (PreloadableEmbeddedPostgresContextCustomizer)o;
            return this.databaseAnnotations.equals(that.databaseAnnotations);
        }

        public int hashCode() {
            return this.databaseAnnotations.hashCode();
        }
    }
}

