/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.proxy.support;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.HttpBasedServiceCredentials;
import org.jasig.cas.ticket.proxy.ProxyHandler;
import org.jasig.cas.util.DefaultUniqueTicketIdGenerator;
import org.jasig.cas.util.UniqueTicketIdGenerator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public final class Cas20ProxyHandler
implements ProxyHandler,
InitializingBean {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String PGTIOU_PREFIX = "PGTIOU";
    private static final int[] DEFAULT_ACCEPTABLE_CODES = new int[]{200, 304, 302, 301, 202};
    private int[] acceptableCodes;
    private UniqueTicketIdGenerator uniqueTicketIdGenerator;
    private HttpClient httpClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String handle(Credentials credentials, String proxyGrantingTicketId) {
        StringBuffer stringBuffer;
        HttpBasedServiceCredentials serviceCredentials = (HttpBasedServiceCredentials)credentials;
        String proxyIou = this.uniqueTicketIdGenerator.getNewTicketId(PGTIOU_PREFIX);
        StringBuffer stringBuffer2 = stringBuffer = new StringBuffer();
        synchronized (stringBuffer2) {
            stringBuffer.append(serviceCredentials.getCallbackUrl().toExternalForm());
            if (serviceCredentials.getCallbackUrl().getQuery() != null) {
                stringBuffer.append("&");
            } else {
                stringBuffer.append("?");
            }
            stringBuffer.append("pgtIou=");
            stringBuffer.append(proxyIou);
            stringBuffer.append("&pgtId=");
            stringBuffer.append(proxyGrantingTicketId);
        }
        GetMethod getMethod = new GetMethod(stringBuffer.toString());
        try {
            this.httpClient.executeMethod((HttpMethod)getMethod);
            int responseCode = getMethod.getStatusCode();
            for (int i = 0; i < this.acceptableCodes.length; ++i) {
                if (responseCode != this.acceptableCodes[i]) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Sent ProxyIou of " + proxyIou + " for service: " + serviceCredentials.getCallbackUrl()));
                }
                String string = proxyIou;
                return string;
            }
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
        }
        finally {
            getMethod.releaseConnection();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Failed to send ProxyIou of " + proxyIou + " for service: " + serviceCredentials.getCallbackUrl()));
        }
        return null;
    }

    public void setUniqueTicketIdGenerator(UniqueTicketIdGenerator uniqueTicketIdGenerator) {
        this.uniqueTicketIdGenerator = uniqueTicketIdGenerator;
    }

    public void setAcceptableCodes(int[] acceptableCodes) {
        this.acceptableCodes = acceptableCodes;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.httpClient, (String)"httpClient cannot be null.");
        if (this.uniqueTicketIdGenerator == null) {
            this.uniqueTicketIdGenerator = new DefaultUniqueTicketIdGenerator();
            this.log.info((Object)("No UniqueTicketIdGenerator specified for " + this.getClass().getName() + ".  Using " + this.uniqueTicketIdGenerator.getClass().getName()));
        }
        if (this.acceptableCodes == null) {
            this.acceptableCodes = DEFAULT_ACCEPTABLE_CODES;
        }
    }
}

