/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import java.util.List;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.AbstractTicketRegistry;

public abstract class AbstractDistributedTicketRegistry
extends AbstractTicketRegistry {
    protected abstract void updateTicket(Ticket var1);

    protected Ticket getProxiedTicketInstance(Ticket ticket) {
        if (ticket == null) {
            return null;
        }
        if (ticket instanceof ServiceTicket) {
            return new ProxiedServiceTicket((ServiceTicket)ticket, this);
        }
        return new ProxiedTicketGrantingTicket((TicketGrantingTicket)ticket, this);
    }

    private final class ProxiedTicketGrantingTicket
    implements TicketGrantingTicket {
        private static final long serialVersionUID = -4361481214176025025L;
        private final TicketGrantingTicket ticket;
        private final AbstractDistributedTicketRegistry ticketRegistry;

        protected ProxiedTicketGrantingTicket(TicketGrantingTicket ticket, AbstractDistributedTicketRegistry ticketRegistry) {
            this.ticket = ticket;
            this.ticketRegistry = ticketRegistry;
        }

        public long getCreationTime() {
            return this.ticket.getCreationTime();
        }

        public TicketGrantingTicket getGrantingTicket() {
            return this.ticket.getGrantingTicket();
        }

        public String getId() {
            return this.ticket.getId();
        }

        public boolean isExpired() {
            return this.ticket.isExpired();
        }

        public void expire() {
            this.ticket.expire();
            this.ticketRegistry.updateTicket(this.ticket);
        }

        public Authentication getAuthentication() {
            return this.ticket.getAuthentication();
        }

        public List getChainedAuthentications() {
            return this.ticket.getChainedAuthentications();
        }

        public ServiceTicket grantServiceTicket(String id, Service service, ExpirationPolicy expirationPolicy, boolean credentialsProvided) {
            ServiceTicket serviceTicket = this.ticket.grantServiceTicket(id, service, expirationPolicy, credentialsProvided);
            this.ticketRegistry.updateTicket(this.ticket);
            return serviceTicket;
        }

        public boolean isRoot() {
            return this.ticket.isRoot();
        }

        public boolean equals(Object obj) {
            return this.ticket.equals(obj);
        }

        public String toString() {
            return this.ticket.toString();
        }
    }

    private final class ProxiedServiceTicket
    implements ServiceTicket {
        private static final long serialVersionUID = -8212338455270445676L;
        private final ServiceTicket serviceTicket;
        private AbstractDistributedTicketRegistry ticketRegistry;

        protected ProxiedServiceTicket(ServiceTicket serviceTicket, AbstractDistributedTicketRegistry ticketRegistry) {
            this.serviceTicket = serviceTicket;
            this.ticketRegistry = ticketRegistry;
        }

        public Service getService() {
            return this.serviceTicket.getService();
        }

        public TicketGrantingTicket grantTicketGrantingTicket(String id, Authentication authentication, ExpirationPolicy expirationPolicy) {
            return this.serviceTicket.grantTicketGrantingTicket(id, authentication, expirationPolicy);
        }

        public boolean isFromNewLogin() {
            return this.serviceTicket.isFromNewLogin();
        }

        public long getCreationTime() {
            return this.serviceTicket.getCreationTime();
        }

        public TicketGrantingTicket getGrantingTicket() {
            return this.serviceTicket.getGrantingTicket();
        }

        public String getId() {
            return this.serviceTicket.getId();
        }

        public boolean isValidFor(Service service) {
            boolean result = this.serviceTicket.isValidFor(service);
            this.ticketRegistry.updateTicket(this.serviceTicket);
            return result;
        }

        public boolean isExpired() {
            return this.serviceTicket.isExpired();
        }

        public boolean equals(Object obj) {
            return this.serviceTicket.equals(obj);
        }

        public String toString() {
            return this.serviceTicket.toString();
        }
    }
}

