/*
 * Decompiled with CFR 0.152.
 */
package jain.protocol.ip.mgcp.message;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.message.parms.BearerInformation;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConflictingParameterException;
import jain.protocol.ip.mgcp.message.parms.ConnectionDescriptor;
import jain.protocol.ip.mgcp.message.parms.ConnectionMode;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.LocalOptionValue;
import jain.protocol.ip.mgcp.message.parms.NotificationRequestParms;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;

public final class CreateConnection
extends JainMgcpCommandEvent {
    private CallIdentifier callIdentifier = null;
    private BearerInformation bearerInformation = null;
    private LocalOptionValue[] localConnectionOptions = null;
    private ConnectionMode mode = null;
    private NotificationRequestParms notificationRequestParms = null;
    private NotifiedEntity notifiedEntity = null;
    private ConnectionDescriptor remoteConnectionDescriptor = null;
    private EndpointIdentifier secondEndpointIdentifier = null;

    public CreateConnection(Object source, CallIdentifier callIdentifier, EndpointIdentifier endpointIdentifier, ConnectionMode mode) throws IllegalArgumentException {
        super(source, endpointIdentifier, 103);
        this.setCallIdentifier(callIdentifier);
        this.setMode(mode);
    }

    public void setCallIdentifier(CallIdentifier callIdentifier) throws IllegalArgumentException {
        if (callIdentifier == null) {
            throw new IllegalArgumentException("Call Identifier cannot be null-valued!");
        }
        this.callIdentifier = callIdentifier;
    }

    public void setNotifiedEntity(NotifiedEntity notifiedEntity) {
        this.notifiedEntity = notifiedEntity;
    }

    public void setLocalConnectionOptions(LocalOptionValue[] localConnectionOptions) {
        this.localConnectionOptions = localConnectionOptions;
    }

    public void setMode(ConnectionMode mode) throws IllegalArgumentException {
        if (mode == null) {
            throw new IllegalArgumentException("Mode parameter cannot be null-valued!");
        }
        this.mode = mode;
    }

    public void setRemoteConnectionDescriptor(ConnectionDescriptor remoteConnectionDescriptor) throws ConflictingParameterException {
        if (this.secondEndpointIdentifier != null) {
            throw new ConflictingParameterException("Second Endpoint Identifier is already set; you cannot set Remote Connection Descriptor!");
        }
        this.remoteConnectionDescriptor = remoteConnectionDescriptor;
    }

    public void setSecondEndpointIdentifier(EndpointIdentifier secondEndpointIdentifier) throws ConflictingParameterException {
        if (this.remoteConnectionDescriptor != null) {
            throw new ConflictingParameterException("Remote Connection Descriptor is already set; you cannot set Second Endpoint Identifier!");
        }
        this.secondEndpointIdentifier = secondEndpointIdentifier;
    }

    public void setNotificationRequestParms(NotificationRequestParms notificationRequestParms) {
        this.notificationRequestParms = notificationRequestParms;
    }

    public void setBearerInformation(BearerInformation bearerInformation) {
        this.bearerInformation = bearerInformation;
    }

    public CallIdentifier getCallIdentifier() {
        return this.callIdentifier;
    }

    public NotifiedEntity getNotifiedEntity() {
        return this.notifiedEntity;
    }

    public LocalOptionValue[] getLocalConnectionOptions() {
        return this.localConnectionOptions;
    }

    public ConnectionMode getMode() {
        return this.mode;
    }

    public ConnectionDescriptor getRemoteConnectionDescriptor() {
        return this.remoteConnectionDescriptor;
    }

    public EndpointIdentifier getSecondEndpointIdentifier() {
        return this.secondEndpointIdentifier;
    }

    public NotificationRequestParms getNotificationRequestParms() {
        return this.notificationRequestParms;
    }

    public BearerInformation getBearerInformation() {
        return this.bearerInformation;
    }

    public String toString() {
        String text = super.BuildCommandHeader("CRCX");
        if (this.callIdentifier != null) {
            text = text + "C: " + this.callIdentifier.toString() + "\n";
        }
        if (this.bearerInformation != null) {
            text = text + "B: e:" + this.bearerInformation.toString() + "\n";
        }
        if (this.localConnectionOptions != null) {
            text = text + super.BuildListParmLine("L", this.localConnectionOptions);
        }
        if (this.mode != null) {
            text = text + "M: " + this.mode.toString() + "\n";
        }
        if (this.notificationRequestParms != null) {
            text = text + this.notificationRequestParms.toString();
        }
        if (this.notifiedEntity != null) {
            text = text + "N: " + this.notifiedEntity.toString() + "\n";
        }
        if (this.secondEndpointIdentifier != null) {
            text = text + "Z2: " + this.secondEndpointIdentifier.toString() + "\n";
        }
        if (this.remoteConnectionDescriptor != null) {
            text = text + "\n" + this.remoteConnectionDescriptor + "\n";
        }
        return text;
    }
}

