/*
 * Decompiled with CFR 0.152.
 */
package jain.protocol.ip.mgcp.message;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.message.parms.BearerInformation;
import jain.protocol.ip.mgcp.message.parms.DigitMap;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.QuarantineHandling;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.RequestedEvent;

public final class NotificationRequest
extends JainMgcpCommandEvent {
    private EventName[] detectEvents = null;
    private DigitMap digitMap = null;
    private BearerInformation bearerInformation = null;
    private NotifiedEntity notifiedEntity = null;
    private QuarantineHandling quarantineHandling = null;
    private RequestedEvent[] requestedEvents = null;
    private RequestIdentifier requestIdentifier = null;
    private EventName[] signalRequests = null;

    public NotificationRequest(Object source, EndpointIdentifier endpointIdentifier, RequestIdentifier requestIdentifier) throws IllegalArgumentException {
        super(source, endpointIdentifier, 107);
        this.setRequestIdentifier(requestIdentifier);
    }

    public void setNotifiedEntity(NotifiedEntity notifiedEntity) {
        this.notifiedEntity = notifiedEntity;
    }

    public void setRequestedEvents(RequestedEvent[] requestedEvents) {
        this.requestedEvents = requestedEvents;
    }

    public void setRequestIdentifier(RequestIdentifier requestIdentifier) throws IllegalArgumentException {
        if (requestIdentifier == null) {
            throw new IllegalArgumentException("Request identifier cannot be null-valued!");
        }
        this.requestIdentifier = requestIdentifier;
    }

    public void setDigitMap(DigitMap digitMap) {
        this.digitMap = digitMap;
    }

    public void setSignalRequests(EventName[] signalRequests) {
        this.signalRequests = signalRequests;
    }

    public void setQuarantineHandling(QuarantineHandling quarantineHandling) {
        this.quarantineHandling = quarantineHandling;
    }

    public void setDetectEvents(EventName[] detectEvents) {
        this.detectEvents = detectEvents;
    }

    public void setBearerInformation(BearerInformation bearerInformation) {
        this.bearerInformation = bearerInformation;
    }

    public NotifiedEntity getNotifiedEntity() {
        return this.notifiedEntity;
    }

    public RequestedEvent[] getRequestedEvents() {
        return this.requestedEvents;
    }

    public RequestIdentifier getRequestIdentifier() {
        return this.requestIdentifier;
    }

    public DigitMap getDigitMap() {
        return this.digitMap;
    }

    public EventName[] getSignalRequests() {
        return this.signalRequests;
    }

    public QuarantineHandling getQuarantineHandling() {
        return this.quarantineHandling;
    }

    public EventName[] getDetectEvents() {
        return this.detectEvents;
    }

    public BearerInformation getBearerInformation() {
        return this.bearerInformation;
    }

    public String toString() {
        String text = super.BuildCommandHeader("RQNT");
        if (this.detectEvents != null) {
            text = text + super.BuildListParmLine("T", this.detectEvents);
        }
        if (this.digitMap != null) {
            text = text + "D: " + this.digitMap.toString() + "\n";
        }
        if (this.bearerInformation != null) {
            text = text + "B: e:" + this.bearerInformation.toString() + "\n";
        }
        if (this.notifiedEntity != null) {
            text = text + "N: " + this.notifiedEntity.toString() + "\n";
        }
        if (this.quarantineHandling != null) {
            text = text + "Q: " + this.quarantineHandling.toString() + "\n";
        }
        if (this.requestedEvents != null) {
            text = text + super.BuildListParmLine("R", this.requestedEvents);
        }
        if (this.requestIdentifier != null) {
            text = text + "X: " + this.requestIdentifier.toString() + "\n";
        }
        if (this.signalRequests != null) {
            text = text + super.BuildListParmLine("S", this.signalRequests);
        }
        return text;
    }
}

