/*
 * Decompiled with CFR 0.152.
 */
package javax.enterprise.inject.spi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDIProvider;

public abstract class CDI<T>
implements Instance<T>,
AutoCloseable {
    protected static volatile Set<CDIProvider> discoveredProviders = null;
    protected static volatile CDIProvider configuredProvider = null;
    private static final Object lock = new Object();
    private static final Pattern nonCommentPattern = Pattern.compile("^([^#]+)");

    public static CDI<Object> current() {
        return CDI.getCDIProvider().getCDI();
    }

    public static void setCDIProvider(CDIProvider provider) {
        if (provider == null) {
            throw new IllegalStateException("CDIProvider must not be null");
        }
        configuredProvider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CDIProvider getCDIProvider() {
        if (configuredProvider != null) {
            return configuredProvider;
        }
        if (discoveredProviders == null) {
            Object object = lock;
            synchronized (object) {
                if (discoveredProviders == null) {
                    CDI.findAllProviders();
                }
            }
        }
        configuredProvider = discoveredProviders.stream().filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalStateException("Unable to locate CDIProvider"));
        return configuredProvider;
    }

    public abstract void shutdown();

    @Override
    public void close() {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void findAllProviders() {
        LinkedHashSet providers = new LinkedHashSet();
        try {
            ClassLoader loader = CDI.class.getClassLoader();
            Enumeration<URL> resources = loader != null ? loader.getResources("META-INF/services/" + CDIProvider.class.getName()) : ClassLoader.getSystemResources("META-INF/services/" + CDIProvider.class.getName());
            HashSet<String> names = new HashSet<String>();
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                try (InputStream is = url.openStream();){
                    names.addAll(CDI.providerNamesFromReader(new BufferedReader(new InputStreamReader(is))));
                }
            }
            for (String s : names) {
                Class<?> providerClass = Class.forName(s, true, loader);
                providers.add(providerClass.newInstance());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        discoveredProviders = Collections.unmodifiableSet(providers);
    }

    private static Set<String> providerNamesFromReader(BufferedReader reader) throws IOException {
        String line;
        HashSet<String> names = new HashSet<String>();
        while ((line = reader.readLine()) != null) {
            Matcher m = nonCommentPattern.matcher(line = line.trim());
            if (!m.find()) continue;
            names.add(m.group().trim());
        }
        return names;
    }

    public abstract BeanManager getBeanManager();
}

