/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.MessageFactory;

public class EnumConverter
implements Converter,
StateHolder {
    public static final String CONVERTER_ID = "javax.faces.Enum";
    public static final String ENUM_ID = "javax.faces.converter.EnumConverter.ENUM";
    public static final String ENUM_NO_CLASS_ID = "javax.faces.converter.EnumConverter.ENUM_NO_CLASS";
    private Class targetClass;
    private transient boolean isTransient = false;

    public EnumConverter() {
    }

    public EnumConverter(Class targetClass) {
        this.targetClass = targetClass;
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() < 1) {
            return null;
        }
        Object result = null;
        if (null != this.targetClass) {
            T[] enumConstants = this.targetClass.getEnumConstants();
            String curName = null;
            if (null != enumConstants) {
                for (Object cur : enumConstants) {
                    curName = cur.toString();
                    if (null == curName || !curName.equals(value)) continue;
                    result = cur;
                    break;
                }
            }
            if (null == result) {
                curName = null != curName ? curName : "";
                throw new ConverterException(MessageFactory.getMessage(context, ENUM_ID, value, curName, MessageFactory.getLabel(context, component)));
            }
        }
        return result;
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return "";
        }
        String result = null;
        if (null != this.targetClass) {
            T[] enumConstants;
            for (Object cur : enumConstants = this.targetClass.getEnumConstants()) {
                if (!value.equals(cur)) continue;
                result = cur.toString();
            }
        }
        result = value.toString();
        return result;
    }

    public void restoreState(FacesContext facesContext, Object object) {
        this.targetClass = (Class)object;
    }

    public Object saveState(FacesContext facesContext) {
        return this.targetClass;
    }

    public void setTransient(boolean b) {
        this.isTransient = b;
    }

    public boolean isTransient() {
        return this.isTransient;
    }
}

