/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.descriptors.changetracking;

import java.io.Serializable;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.descriptors.DescriptorEvent;
import oracle.toplink.essentials.descriptors.changetracking.ObjectChangePolicy;
import oracle.toplink.essentials.internal.descriptors.ObjectBuilder;
import oracle.toplink.essentials.internal.helper.IdentityHashtable;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.MergeManager;
import oracle.toplink.essentials.internal.sessions.ObjectChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.queryframework.WriteObjectQuery;

public class DeferredChangeDetectionPolicy
implements ObjectChangePolicy,
Serializable {
    public ObjectChangeSet calculateChanges(Object clone, Object backUp, UnitOfWorkChangeSet changeSet, AbstractSession session, ClassDescriptor descriptor, boolean shouldRiseEvent) {
        boolean isNew;
        boolean bl = isNew = backUp == null || ((UnitOfWorkImpl)session).isObjectNew(clone) && !descriptor.isAggregateDescriptor();
        if (descriptor.getEventManager().hasAnyEventListeners() && shouldRiseEvent) {
            WriteObjectQuery writeQuery = new WriteObjectQuery(clone.getClass());
            writeQuery.setObject(clone);
            writeQuery.setBackupClone(backUp);
            writeQuery.setSession(session);
            writeQuery.setDescriptor(descriptor);
            descriptor.getEventManager().executeEvent(new DescriptorEvent(0, writeQuery));
            if (isNew) {
                descriptor.getEventManager().executeEvent(new DescriptorEvent(4, writeQuery));
            } else {
                descriptor.getEventManager().executeEvent(new DescriptorEvent(6, writeQuery));
            }
        }
        ObjectChangeSet changes = this.createObjectChangeSet(clone, backUp, changeSet, isNew, session, descriptor);
        changes.setShouldModifyVersionField((Boolean)((UnitOfWorkImpl)session).getOptimisticReadLockObjects().get(clone));
        if (changes.hasChanges() || changes.hasForcedChanges()) {
            return changes;
        }
        return null;
    }

    public void clearChanges(Object object, UnitOfWorkImpl uow, ClassDescriptor descriptor) {
    }

    public ObjectChangeSet createObjectChangeSet(Object clone, Object backUp, UnitOfWorkChangeSet changeSet, boolean isNew, AbstractSession session, ClassDescriptor descriptor) {
        return this.createObjectChangeSetThroughComparison(clone, backUp, changeSet, isNew, session, descriptor);
    }

    public ObjectChangeSet createObjectChangeSetThroughComparison(Object clone, Object backUp, UnitOfWorkChangeSet changeSet, boolean isNew, AbstractSession session, ClassDescriptor descriptor) {
        ObjectBuilder builder = descriptor.getObjectBuilder();
        ObjectChangeSet changes = builder.createObjectChangeSet(clone, changeSet, isNew, session);
        if (descriptor.usesOptimisticLocking() && changes.getPrimaryKeys() != null) {
            changes.setOptimisticLockingPolicyAndInitialWriteLockValue(descriptor.getOptimisticLockingPolicy(), session);
        }
        Vector mappings = descriptor.getMappings();
        int mappingsSize = mappings.size();
        for (int index = 0; index < mappingsSize; ++index) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(index);
            changes.addChange(mapping.compareForChange(clone, backUp, changes, session));
        }
        return changes;
    }

    public void dissableEventProcessing(Object changeTracker) {
    }

    public void enableEventProcessing(Object changeTracker) {
    }

    public boolean shouldCompareForChange(Object object, UnitOfWorkImpl unitOfWork, ClassDescriptor descriptor) {
        return true;
    }

    public Object buildBackupClone(Object clone, ObjectBuilder builder, UnitOfWorkImpl uow) {
        return builder.buildBackupClone(clone, uow);
    }

    public void setAggregateChangeListener(Object parent, Object aggregate, UnitOfWorkImpl uow, ClassDescriptor descriptor, String mappingAttribute) {
    }

    public void setChangeListener(Object clone, UnitOfWorkImpl uow, ClassDescriptor descriptor) {
    }

    public void setChangeSetOnListener(ObjectChangeSet objectChangeSet, Object clone) {
    }

    public void updateWithChanges(Object clone, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow, ClassDescriptor descriptor) {
        if (objectChangeSet == null) {
            return;
        }
        Object backupClone = uow.getCloneMapping().get(clone);
        if (backupClone != null) {
            MergeManager mergeManager = new MergeManager(uow);
            mergeManager.setCascadePolicy(1);
            descriptor.getObjectBuilder().mergeChangesIntoObject(backupClone, objectChangeSet, clone, mergeManager);
        }
        this.clearChanges(clone, uow, descriptor);
    }

    public void raiseInternalPropertyChangeEvent(Object source, String propertyName, Object oldValue, Object newValue) {
    }

    public void revertChanges(Object clone, ClassDescriptor descriptor, UnitOfWorkImpl uow, IdentityHashtable cloneMapping) {
        cloneMapping.put(clone, this.buildBackupClone(clone, descriptor.getObjectBuilder(), uow));
        this.clearChanges(clone, uow, descriptor);
    }

    public void initialize(AbstractSession session, ClassDescriptor descriptor) {
    }

    public boolean isDeferredChangeDetectionPolicy() {
        return true;
    }

    public boolean isObjectChangeTrackingPolicy() {
        return false;
    }

    public boolean isAttributeChangeTrackingPolicy() {
        return false;
    }
}

