/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BasicTypeHelperImpl {
    private static Set integralTypes = new HashSet();
    private static Set floatingPointTypes = new HashSet();
    private static Set dateClasses = new HashSet();
    private static Map primitiveToWrapper = new HashMap();
    private static Map wrapperToPrimitive = new HashMap();

    public Object getObjectType() {
        return Object.class;
    }

    public Object getBooleanType() {
        return Boolean.TYPE;
    }

    public Object getBooleanWrapperClass() {
        return Boolean.class;
    }

    public Object getCharType() {
        return Character.TYPE;
    }

    public Object getIntType() {
        return Integer.TYPE;
    }

    public Object getLongType() {
        return Long.TYPE;
    }

    public Object getLongClassType() {
        return Long.class;
    }

    public Object getFloatType() {
        return Float.TYPE;
    }

    public Object getDoubleType() {
        return Double.TYPE;
    }

    public Object getDoubleClassType() {
        return Double.class;
    }

    public Object getStringType() {
        return String.class;
    }

    public Object getBigIntegerType() {
        return BigInteger.class;
    }

    public Object getBigDecimalType() {
        return BigDecimal.class;
    }

    public Object getDateType() {
        return Date.class;
    }

    public boolean isEnumType(Object type) {
        Class clazz = (Class)type;
        return clazz != null && clazz.getEnumConstants() != null;
    }

    public boolean isNumericType(Object type) {
        return this.isIntegralType(type) || this.isFloatingPointType(type) || this.isBigIntegerType(type) || this.isBigDecimalType(type);
    }

    public boolean isIntegralType(Object type) {
        return integralTypes.contains(type);
    }

    public boolean isFloatingPointType(Object type) {
        return floatingPointTypes.contains(type);
    }

    public boolean isWrapperClass(Object type) {
        return wrapperToPrimitive.containsKey(type);
    }

    public boolean isStringType(Object type) {
        return type == this.getStringType();
    }

    public boolean isDateClass(Object type) {
        return dateClasses.contains(type);
    }

    public boolean isBigIntegerType(Object type) {
        return type == this.getBigIntegerType();
    }

    public boolean isBigDecimalType(Object type) {
        return type == this.getBigDecimalType();
    }

    public boolean isOrderableType(Object type) {
        return this.isNumericType(type) || this.isStringType(type) || this.isDateClass(type) || this.isEnumType(type);
    }

    public boolean isAssignableFrom(Object left, Object right) {
        if (left == null || right == null) {
            return false;
        }
        if (left == right) {
            return true;
        }
        Object promoted = this.extendedBinaryNumericPromotion(left, right);
        if (promoted != null) {
            return true;
        }
        if (this.isDateClass(left) && this.isDateClass(right)) {
            return true;
        }
        if (this.isBoolean(left) && this.isBoolean(right)) {
            return true;
        }
        return ((Class)left).isAssignableFrom((Class)right);
    }

    public Object extendedBinaryNumericPromotion(Object left, Object right) {
        if (left == null || right == null || !this.isNumericType(left) || !this.isNumericType(right)) {
            return null;
        }
        if (this.isBigDecimalType(left) || this.isBigDecimalType(right)) {
            return this.getBigDecimalType();
        }
        if (this.isBigIntegerType(left)) {
            return this.isFloatingPointType(right) ? right : this.getBigIntegerType();
        }
        if (this.isBigIntegerType(right)) {
            return this.isFloatingPointType(left) ? left : this.getBigIntegerType();
        }
        boolean wrapper = false;
        if (this.isWrapperClass(left)) {
            wrapper = true;
            left = this.getPrimitiveType(left);
        }
        if (this.isWrapperClass(right)) {
            wrapper = true;
            right = this.getPrimitiveType(right);
        }
        Object promoted = this.binaryNumericPromotion(left, right);
        if (wrapper && promoted != null) {
            promoted = this.getWrapperClass(promoted);
        }
        return promoted;
    }

    protected Object getPrimitiveType(Object wrapper) {
        return wrapperToPrimitive.get(wrapper);
    }

    protected Object getWrapperClass(Object primitive) {
        return primitiveToWrapper.get(primitive);
    }

    protected boolean isBoolean(Object type) {
        return type == this.getBooleanType() || type == this.getBooleanWrapperClass();
    }

    protected Object binaryNumericPromotion(Object left, Object right) {
        if (left == null || right == null) {
            return null;
        }
        Object type = null;
        if (left == this.getDoubleType() || right == this.getDoubleType()) {
            type = this.getDoubleType();
        } else if (left == this.getFloatType() || right == this.getFloatType()) {
            type = this.getFloatType();
        } else if (left == this.getLongType() || right == this.getLongType()) {
            type = this.getLongType();
        } else if (this.isIntegralType(left) && this.isIntegralType(right)) {
            type = this.getIntType();
        }
        return type;
    }

    static {
        integralTypes.add(Byte.TYPE);
        integralTypes.add(Byte.class);
        integralTypes.add(Short.TYPE);
        integralTypes.add(Short.class);
        integralTypes.add(Character.TYPE);
        integralTypes.add(Character.class);
        integralTypes.add(Integer.TYPE);
        integralTypes.add(Integer.class);
        integralTypes.add(Long.TYPE);
        integralTypes.add(Long.class);
        floatingPointTypes.add(Float.TYPE);
        floatingPointTypes.add(Float.class);
        floatingPointTypes.add(Double.TYPE);
        floatingPointTypes.add(Double.class);
        dateClasses.add(Date.class);
        dateClasses.add(Calendar.class);
        dateClasses.add(java.sql.Date.class);
        dateClasses.add(Time.class);
        dateClasses.add(Timestamp.class);
        primitiveToWrapper.put(Boolean.TYPE, Boolean.class);
        primitiveToWrapper.put(Byte.TYPE, Byte.class);
        primitiveToWrapper.put(Short.TYPE, Short.class);
        primitiveToWrapper.put(Character.TYPE, Character.class);
        primitiveToWrapper.put(Integer.TYPE, Integer.class);
        primitiveToWrapper.put(Long.TYPE, Long.class);
        primitiveToWrapper.put(Float.TYPE, Float.class);
        primitiveToWrapper.put(Double.TYPE, Double.class);
        wrapperToPrimitive.put(Boolean.class, Boolean.TYPE);
        wrapperToPrimitive.put(Byte.class, Byte.TYPE);
        wrapperToPrimitive.put(Short.class, Short.TYPE);
        wrapperToPrimitive.put(Character.class, Character.TYPE);
        wrapperToPrimitive.put(Integer.class, Integer.TYPE);
        wrapperToPrimitive.put(Long.class, Long.TYPE);
        wrapperToPrimitive.put(Float.class, Float.TYPE);
        wrapperToPrimitive.put(Double.class, Double.TYPE);
    }
}

