/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sdp.fields;

import gov.nist.core.NameValue;
import gov.nist.javax.sdp.fields.AttributeField;
import java.io.Serializable;
import java.util.Vector;
import javax.sdp.SdpException;
import javax.sdp.SdpParseException;

public class PreconditionFields
implements Serializable {
    protected Vector preconditionAttributes = new Vector();
    public static final int STRENGTH_UNKNOWN = 0;
    public static final int STRENGTH_FAILURE = 1;
    public static final int STRENGTH_NONE = 2;
    public static final int STRENGTH_OPTIONAL = 3;
    public static final int STRENGTH_MANDATORY = 4;
    public static final String[] STRENGTH = new String[]{"unknown", "failure", "none", "optional", "mandatory"};
    public static final int DIRECTION_NONE = 0;
    public static final int DIRECTION_SEND = 1;
    public static final int DIRECTION_RECV = 2;
    public static final int DIRECTION_SENDRECV = 3;
    public static final String[] DIRECTION = new String[]{"none", "send", "recv", "sendrecv"};
    public static final int STATUS_E2E = 0;
    public static final int STATUS_LOCAL = 1;
    public static final int STATUS_REMOTE = 2;
    public static final String[] STATUS = new String[]{"e2e", "local", "remote"};
    public static final int PRECONDITION_QOS = 0;
    public static final String[] PRECONDITION = new String[]{"qos"};

    public int getPreconditionSize() {
        if (this.preconditionAttributes != null) {
            return this.preconditionAttributes.size();
        }
        return -1;
    }

    public Vector getPreconditions() {
        return this.preconditionAttributes;
    }

    public void setPreconditions(Vector preconditions) throws SdpException {
        if (preconditions == null) {
            throw new SdpException("Precondition attributes are null");
        }
        this.preconditionAttributes = preconditions;
    }

    public void setPreconditionCurr(String precondCurrValue) throws SdpException {
        if (precondCurrValue == null) {
            throw new SdpException("The Precondition \"curr\" attribute value is null");
        }
        if (this.preconditionAttributes == null) {
            throw new SdpException("The Precondition Attributes is null");
        }
        try {
            String[] attributes = precondCurrValue.split(" ");
            this.setPreconditionCurr(attributes[1], attributes[2]);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new SdpException("Error spliting the \"curr\" attribute into words", ex);
        }
    }

    public void setPreconditionCurr(String status, String directionTag) throws SdpException {
        if (status == null) {
            throw new SdpException("The status-type is null");
        }
        if (directionTag == null) {
            throw new SdpException("The direction-tag is null");
        }
        if (this.preconditionAttributes == null) {
            throw new SdpException("Precondition Attributes is null");
        }
        int i = 0;
        for (i = 0; i < this.preconditionAttributes.size(); ++i) {
            AttributeField af = (AttributeField)this.preconditionAttributes.elementAt(i);
            if (!af.getAttribute().getName().equals("curr") || af.getValue().indexOf(status) == -1) continue;
            if (af.getValue().indexOf(directionTag) != -1) break;
            af.setValue("qos " + status + " " + directionTag);
            this.preconditionAttributes.setElementAt(af, i);
        }
        if (i == this.preconditionAttributes.size()) {
            NameValue nv = new NameValue("curr", "qos " + status + " " + directionTag);
            AttributeField newAF = new AttributeField();
            newAF.setAttribute(nv);
            this.preconditionAttributes.add(newAF);
        }
    }

    public void setPreconditionDes(String precondDesValue) throws SdpException {
        if (precondDesValue == null) {
            throw new SdpException("The Precondition \"des\" attribute value is null");
        }
        if (this.preconditionAttributes == null) {
            throw new SdpException("The Precondition Attributes is null");
        }
        try {
            String[] attributes = precondDesValue.split(" ");
            this.setPreconditionDes(attributes[1], attributes[2], attributes[3]);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new SdpException("Error spliting the \"des\" attribute into words", ex);
        }
    }

    public void setPreconditionDes(String strength, String status, String direction) throws SdpException {
        if (strength == null) {
            throw new SdpException("The strength-tag is null");
        }
        if (status == null) {
            throw new SdpException("The status-type is null");
        }
        if (direction == null) {
            throw new SdpException("The direction-tag is null");
        }
        if (this.preconditionAttributes == null) {
            throw new SdpException("Precondition Attributes is null");
        }
        int i = 0;
        for (i = 0; i < this.preconditionAttributes.size(); ++i) {
            AttributeField af = (AttributeField)this.preconditionAttributes.elementAt(i);
            if (!af.getAttribute().getName().equals("des") || af.getValue().indexOf(status) == -1) continue;
            af.setValue("qos " + strength + " " + status + " " + direction);
            this.preconditionAttributes.setElementAt(af, i);
        }
        if (i == this.preconditionAttributes.size()) {
            NameValue nv = new NameValue("des", "qos " + strength + " " + status + " " + direction);
            AttributeField newAF = new AttributeField();
            newAF.setAttribute(nv);
            this.preconditionAttributes.add(newAF);
        }
    }

    public void setPreconditionConfirmStatus(String precondConfValue) throws SdpException {
        if (precondConfValue == null || precondConfValue.length() == 0) {
            throw new SdpException("The Precondition \"conf\" attribute value is null");
        }
        if (this.preconditionAttributes == null) {
            throw new SdpException("The Precondition Attributes is null");
        }
        try {
            String[] attributes = precondConfValue.split(" ");
            this.setPreconditionConfirmStatus(attributes[1], attributes[2]);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new SdpException("Error spliting the \"conf\" attribute into words", ex);
        }
    }

    public void setPreconditionConfirmStatus(String status, String direction) throws SdpException {
        if (status == null || direction.length() == 0) {
            throw new SdpException("The status-type is null");
        }
        if (direction == null || direction.length() == 0) {
            throw new SdpException("The direction-tag is null");
        }
        if (this.preconditionAttributes == null) {
            throw new SdpException("Precondition Attributes is null");
        }
        int i = 0;
        for (i = 0; i < this.preconditionAttributes.size(); ++i) {
            AttributeField af = (AttributeField)this.preconditionAttributes.elementAt(i);
            if (!af.getAttribute().getName().equals("conf") || af.getValue().indexOf(status) == -1) continue;
            if (af.getValue().indexOf(direction) != -1) break;
            af.setValue("qos " + status + " " + direction);
            this.preconditionAttributes.setElementAt(af, i);
            break;
        }
        if (i == this.preconditionAttributes.size()) {
            NameValue nv = new NameValue("conf", "qos " + status + " " + direction);
            AttributeField newAF = new AttributeField();
            newAF.setAttribute(nv);
            this.preconditionAttributes.add(newAF);
        }
    }

    public Vector getPreconditionCurr(String status) throws SdpException, SdpParseException {
        if (status == null) {
            throw new SdpException("The status-type is null");
        }
        if (this.preconditionAttributes == null) {
            return null;
        }
        Vector<AttributeField> vCurr = new Vector<AttributeField>();
        for (int i = 0; i < this.preconditionAttributes.size(); ++i) {
            AttributeField af = (AttributeField)this.preconditionAttributes.elementAt(i);
            if (!af.getAttribute().getName().equals("curr") || af.getValue().indexOf(status) == -1) continue;
            vCurr.addElement(af);
        }
        if (vCurr.size() == 0) {
            return null;
        }
        return vCurr;
    }

    public Vector getPreconditionDes(String status) throws SdpException, SdpParseException {
        if (status == null) {
            throw new SdpException("The status-type is null");
        }
        if (this.preconditionAttributes == null) {
            return null;
        }
        Vector<AttributeField> vCurr = new Vector<AttributeField>();
        for (int i = 0; i < this.preconditionAttributes.size(); ++i) {
            AttributeField af = (AttributeField)this.preconditionAttributes.elementAt(i);
            if (!af.getAttribute().getName().equals("des") || af.getValue().indexOf(status) == -1) continue;
            vCurr.addElement(af);
        }
        if (vCurr.size() == 0) {
            return null;
        }
        return vCurr;
    }

    public Vector getPreconditionConfirmStatus() throws SdpException {
        if (this.preconditionAttributes == null) {
            return null;
        }
        Vector<AttributeField> vCurr = new Vector<AttributeField>();
        for (int i = 0; i < this.preconditionAttributes.size(); ++i) {
            AttributeField af = (AttributeField)this.preconditionAttributes.elementAt(i);
            if (!af.getAttribute().getName().equals("conf")) continue;
            vCurr.addElement(af);
        }
        if (vCurr.size() == 0) {
            return null;
        }
        return vCurr;
    }
}

