package javax.slee;

/**
 * This exception is thrown if the activity object supplied to an activity
 * context interface factory method is not an activity generated by a resource
 * adaptor installed in the SLEE.  For example, an activity object directly
 * instantiated by an SBB via <code>new <i>&lt;type&gt;(...)</i></code> would raise an
 * <code>UnrecognizedActivityException</code> if given to an activity context interface
 * factory method.
 * <p>
 * As of SLEE 1.1 this class extends {@link javax.slee.SLEEException} instead of {@link Exception}. 
 */
public class UnrecognizedActivityException extends SLEEException {
    /**
     * Create an <code>UnrecognizedActivityException</code> with no detail message.
     * @param activity the unrecognized activity.
     */
    public UnrecognizedActivityException(Object activity) {
        this(null, activity);
    }

    /**
     * Create an <code>UnrecognizedActivityException</code> with a detail message.
     * @param message the detail message
     * @param activity the unrecognized activity.
     */
    public UnrecognizedActivityException(String message, Object activity) {
        super(message);
        this.activity = activity;
    }

    /**
     * Get the activity that was unrecognized.
     * @return the activity that was unrecognized.
     */
    public final Object getActivity() {
        return activity;
    }


    private final Object activity;
}
