/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.buddyreplication;

import org.jgroups.stack.IpAddress;

import java.util.List;
import java.util.Map;
import java.util.Properties;

/**
 * Buddy Locators help the {@see BuddyManager} select buddies for its buddy group.
 *
 * @author <a href="mailto:manik@jboss.org">Manik Surtani (manik@jboss.org)</a>
 */
public interface BuddyLocator
{
    public void init(Properties props);

    public List locateBuddies(Map buddyPoolMap, List currentMembership, IpAddress dataOwner);
}
